#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

KEY_BIN=""
INSTALL_DIR=/usr/local
while (( "$#" )); do
  case "$1" in
    -i|--install_prefix)
      INSTALL_DIR=$2
      shift 2
      ;;
    -k|--key-bin)
      KEY_BIN=$2
      shift 2
      ;;
    --) # end argument parsing
      shift
      break
      ;;
    -*|--*=) # unsupported flags
      echo "Error: Unsupported options $1" >&2
      exit 1
      ;;
    *) # preserve positional arguments
      PARAMS="$PARAMS $1"
      shift
      ;;
  esac
done

echo "=> install sniper pam service ..."
if [ -d /etc/pam.d/ ] && [ -f $DIR/chkpasswd-nerv ] ; then
    cp $DIR/chkpasswd-nerv /etc/pam.d/
fi

echo "=> install sniper into system service ..."
system_infos=`cat /etc/issue 2> /dev/null`
redhat_version=`cat /etc/redhat-release 2> /dev/null`
cgs_version=`cat /etc/system-release 2> /dev/null`

function like() {
    local match_result=`echo "$1" | grep "$2" | wc -l | awk '{print $1}'`
    [ "$match_result" == "1" ]
}

if [ ! -d "$INSTALL_DIR" ]; then
  mkdir -p "$INSTALL_DIR"
fi

echo "=> install sniper into dir '$INSTALL_DIR/sniper'"
rm -rf $INSTALL_DIR/sniper
cp -r $DIR $INSTALL_DIR/sniper

# 如果安装目录不在/usr/local则建立一个符号链接
if [ ! -d "/usr/local/sniper" ]; then
  echo "create symlink from $INSTALL_DIR/sniper to /usr/local/sniper"
  ln -s "$INSTALL_DIR/sniper" /usr/local/sniper
fi

chmod +x $INSTALL_DIR/sniper/sniper 2> /dev/null
chmod +x $INSTALL_DIR/sniper/upgrade 2> /dev/null
chmod +x $INSTALL_DIR/sniper/*.sh 2> /dev/null

function install_service() {
    echo "=> install service"
    cp service-template /etc/init.d/sniper
    chmod +x /etc/init.d/sniper
    chkconfig --add sniper
    chkconfig --level 2345 sniper on
}

function install_service_for_ubuntu_1404() {
    echo "=> install service for ubuntu 14.04"
    cp service-template /etc/init.d/sniper
    chmod +x /etc/init.d/sniper
    update-rc.d sniper defaults
}

function install_systemd_service() {
    echo "=> install systemd.service"
    mkdir -p /usr/lib/systemd/system/
    cp systemctl-template /usr/lib/systemd/system/sniper.service
    chmod +x /usr/lib/systemd/system/sniper.service
    systemctl daemon-reexec
    systemctl enable sniper.service
}

for ((;;))
do
  if like "$system_infos" "Ubuntu" && (like "$system_infos" "14\.04" || like "$system_infos" "12\.") ; then
    install_service_for_ubuntu_1404
    break
  fi

  which systemctl >/dev/null 2>&1
  if [ "#$?" == "#0" ]; then
    install_systemd_service
    break
  fi

  which service >/dev/null 2>&1
  if [ "#$?" == "#0" ]; then
    install_service
    break
  fi

  echo "=> unsupported os version, install failed!!!"
  echo -e "/etc/issue:\n$system_infos"
  echo -e "/etc/redhat-release:\n$redhat_version"
  ./uninstall.sh
  exit 1
done

# 配置rsyslog日志，对sniperknl模块日志进行过滤以及归档
function config_sniperknl_log() {
	chmod 0644 sniperknl-logrotate
    mkdir -p /etc/rsyslog.d/ /etc/logrotate.d/
    cp sniperknl-rsyslog.conf /etc/rsyslog.d/
    cp sniperknl-logrotate /etc/logrotate.d/
    service rsyslog restart
}

# 配置内核模块日志
if like "$system_infos" "CentOS" && like "$system_infos" "6\."; then
    config_sniperknl_log
elif like "$system_infos" "Red Hat Enterprise Linux Server release" || (like "$redhat_version" "Red Hat Enterprise Linux Server release" && like "$redhat_version" "6\.") ; then
    config_sniperknl_log
else
    echo "sniperknl log record into the system log file '/var/log/messages'"
fi 

# 安装服务脚本
echo "=> install service scripts to /usr/local/sbin"
mkdir -p /usr/local/sbin/
if [ -f $INSTALL_DIR/sniper/startup.sh ] ; then
    ln -sf $INSTALL_DIR/sniper/startup.sh /usr/local/sbin/sniper-start
fi 

if [ -f $INSTALL_DIR/sniper/shutdown.sh ] ; then
    ln -sf $INSTALL_DIR/sniper/shutdown.sh /usr/local/sbin/sniper-stop
fi

if [ -f $INSTALL_DIR/sniper/uninstall.sh ] ; then
    ln -sf $INSTALL_DIR/sniper/uninstall.sh /usr/local/sbin/sniper-uninstall
fi 

if [ -f $INSTALL_DIR/sniper/register.sh ] ; then
    ln -sf $INSTALL_DIR/sniper/register.sh /usr/local/sbin/sniper-regist
    ln -sf $INSTALL_DIR/sniper/register.sh /usr/local/sbin/sniper-register
fi

if [ -f $INSTALL_DIR/sniper/sniper-ctl.sh ] ; then
    ln -sf $INSTALL_DIR/sniper/sniper-ctl.sh /usr/local/sbin/sniper-ctl
fi

# 清除安装后的文件中存在的不必要文件
find $INSTALL_DIR/sniper -name "._*" | xargs -n 1 rm -f

source /etc/profile
# 检查环境变量，如果不存在则设置环境变量，避免upgrade在启动是，不能发现启动问题
echo $PATH | grep -q "/usr/local/sbin"
if [ $? -ne 0 ]; then
  echo 'export PATH=$PATH:/usr/local/sbin/' >> /etc/profile
  source /etc/profile
fi

# 检查当前安装安装包路径是否存在 key.bin 文件或者安装时指定 key.bin 所在的路径文件是否存在，如果存在则安装该key.bin
if [ "#${KEY_BIN}" != "#" ] && [ -f "${KEY_BIN}" ] ; then
    echo "copy the ${KEY_BIN} to the dir $INSTALL_DIR/sniper/config"
    $INSTALL_DIR/sniper/register.sh ${KEY_BIN}
fi

echo "=> sniper installed at $INSTALL_DIR/sniper, you need to manually restart the sniper, or restart the system, thanks!!!"

