#!/bin/bash

source /usr/local/sniper/utils.sh

max_size=10485760
config_file=/etc/logrotate.d/sniperknl-logrotate
/usr/sbin/logrotate ${config_file} >/dev/null 2>&1
EXITVALUE=$?
if [ $EXITVALUE != 0 ]; then
    /usr/bin/logger -t logrotate "ALERT exited abnormally with [$EXITVALUE], config file: ${config_file}"
else
    logger "Sniper kernel log split successfully."
fi 

if [ -f /var/log/sniperknl.log ] ; then
    current_size=`ls -l /var/log/sniperknl.log | awk '{print $5}'`
else
    current_size=0
fi

if [ $current_size -gt $max_size ]; then
    mv /var/log/sniperknl.log  /var/log/sniperknl.log.old
    tar -cvzf /var/log/sniperknl-old.tar.gz /var/log/sniperknl.log.old 
    rm -f /var/log/sniperknl.log.old
    systemctl_service rsyslog restart
    logger "Forced backup sniperknl.log"
fi
exit 0
