CREATE TABLE RULE_TYPE (
        ID BIGINT NOT NULL AUTO_INCREMENT,
        NAME VARCHAR(100),
        RULE_LIB_ID BIGINT,
        RULE_LIB_NAME VARCHAR(100),
        CONSTRAINT RULE_TYPE_PK PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX PRIMARY_KEY_76 ON RULE_TYPE (ID);
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(8, '其他', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(12, '信息泄露', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(13, '恶意攻击', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(14, '协议完整性', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(15, '防爬虫', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(16, '其他', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(1, 'SQL注入', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(2, '跨站脚本攻击', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(3, '扫描器', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(4, '信息泄露', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(5, '恶意攻击', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(6, '协议完整性', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(7, '防爬虫', 1, '通用规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(9, 'SQL注入', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(10, '跨站脚本攻击', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(11, '扫描器', 2, '用友规则库');
INSERT INTO PUBLIC.RULE_TYPE (ID, NAME, RULE_LIB_ID, RULE_LIB_NAME) VALUES(17, 'HTTP校验规则', 3, 'HTTP校检规则库');
DROP TABLE PUBLIC.RULE;
CREATE TABLE RULE (
 ID BIGINT DEFAULT NOT NULL AUTO_INCREMENT,
 NAME VARCHAR(64),
 MODE VARCHAR(64),
 STATUS VARCHAR(64),
 RISK_LEVEL BIGINT,
 REMARK VARCHAR(255),
 CONTENT VARCHAR(9000),
 RULE_ID BIGINT,
 CODE BIGINT,
 RULE_TYPE BIGINT,
 RULE_TYPE_NAME VARCHAR(100)
);
CREATE UNIQUE INDEX PRIMARY_KEY_46 ON RULE (ID);
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(1, 'SQL注入942100', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|REQUEST_HEADERS:User-Agent|REQUEST_HEADERS:Referer|ARGS_NAMES|ARGS|XML:/* "@detectSQLi" "id:942100,phase:2,block,capture,t:none,t:utf8toUnicode,t:urlDecodeUni,t:removeNulls,msg:''SQL Injection Attack Detected via libinjection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-sqli'',tag:''OWASP_CRS/WEB_ATTACK/SQL_INJECTION'',tag:''WASCTC/WASC-19'',tag:''OWASP_TOP_10/A1'',tag:''OWASP_AppSensor/CIE1'',tag:''PCI/6.5.2'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',multiMatch,setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.sql_injection_score=+%{tx.critical_anomaly_score}'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/SQL_INJECTION-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}''"', 6, 942100, 1, 'SQL注入');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(2, 'XSS攻击941100', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|REQUEST_HEADERS:User-Agent|ARGS_NAMES|ARGS|XML:/* "@detectXSS" "id:941100,phase:2,block,t:none,t:utf8toUnicode,t:urlDecodeUni,t:htmlEntityDecode,t:jsDecode,t:cssDecode,t:removeNulls,msg:''XSS Attack Detected via libinjection'',logdata:''Matched Data: XSS data found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-xss'',tag:''OWASP_CRS/WEB_ATTACK/XSS'',tag:''WASCTC/WASC-8'',tag:''WASCTC/WASC-22'',tag:''OWASP_TOP_10/A3'',tag:''OWASP_AppSensor/IE1'',tag:''CAPEC-242'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.xss_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/XSS-%{MATCHED_VAR_NAME}=%{tx.0}''"', 7, 941100, 2, 'XSS攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(3, '黑客恶意攻击扫描913100', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS:User-Agent "@pmFromFile scanners-user-agents.data" "id:913100,phase:2,block,capture,t:none,t:lowercase,msg:''Found User-Agent associated with security scanner'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scanner'',tag:''OWASP_CRS/AUTOMATION/SECURITY_SCANNER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7'',tag:''PCI/6.5.10'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/AUTOMATION/SECURITY_SCANNER-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}'',setvar:''ip.reput_block_flag=1'',setvar:''ip.reput_block_reason=%{rule.msg}'',expirevar:''ip.reput_block_flag=%{tx.reput_block_duration}''"', 8, 913100, 3, '黑客恶意攻击扫描');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(4, '黑客恶意攻击扫描913110', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS_NAMES|REQUEST_HEADERS "@pmf scanners-headers.data" "id:913110,phase:2,block,capture,t:none,t:lowercase,msg:''Found request header associated with security scanner'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scanner'',tag:''OWASP_CRS/AUTOMATION/SECURITY_SCANNER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7'',tag:''PCI/6.5.10'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/AUTOMATION/SECURITY_SCANNER-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}'',setvar:''ip.reput_block_flag=1'',setvar:''ip.reput_block_reason=%{rule.msg}'',expirevar:''ip.reput_block_flag=%{tx.reput_block_duration}''"', 8, 913110, 3, '黑客恶意攻击扫描');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(5, '黑客恶意攻击扫描913120', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS|REQUEST_FILENAME|ARGS "@pmf scanners-urls.data" "id:913120,phase:2,block,capture,t:none,t:lowercase,msg:''Found request filename/argument associated with security scanner'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scanner'',tag:''OWASP_CRS/AUTOMATION/SECURITY_SCANNER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7'',tag:''PCI/6.5.10'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/AUTOMATION/SECURITY_SCANNER-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}'',setvar:''ip.reput_block_flag=1'',setvar:''ip.reput_block_reason=%{rule.msg}'',expirevar:''ip.reput_block_flag=%{tx.reput_block_duration}''"', 8, 913120, 3, '黑客恶意攻击扫描');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(6, '黑客恶意攻击扫描913101', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS:User-Agent "@pmFromFile scripting-user-agents.data" "id:913101,phase:2,block,capture,t:none,t:lowercase,msg:''Found User-Agent associated with scripting/generic HTTP client'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scripting'',tag:''OWASP_CRS/AUTOMATION/SCRIPTING'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7'',tag:''PCI/6.5.10'',tag:''paranoia-level/2'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.anomaly_score_pl2=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/AUTOMATION/SCRIPTING-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}'',setvar:''ip.reput_block_flag=1'',setvar:''ip.reput_block_reason=%{rule.msg}'',expirevar:''ip.reput_block_flag=%{tx.reput_block_duration}''"', 8, 913101, 3, '黑客恶意攻击扫描');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(7, '黑客恶意攻击扫描913102', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS:User-Agent "@pmFromFile crawlers-user-agents.data" "id:913102,phase:2,block,capture,t:none,t:lowercase,msg:''Found User-Agent associated with web crawler/bot'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-crawler'',tag:''OWASP_CRS/AUTOMATION/CRAWLER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7'',tag:''PCI/6.5.10'',tag:''paranoia-level/2'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.anomaly_score_pl2=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/AUTOMATION/CRAWLER-%{MATCHED_VAR_NAME}=%{MATCHED_VAR}'',setvar:''ip.reput_block_flag=1'',setvar:''ip.reput_block_reason=%{rule.msg}'',expirevar:''ip.reput_block_flag=%{tx.reput_block_duration}''"', 8, 913102, 3, '黑客恶意攻击扫描');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(8, '密码暴力破解20', 'alert', 'Y', 1, NULL, 'SecRule DDOS "@rx PASSWD" "id:20,phase:2,block,capture,t:none,t:urlDecodeUni,t:lowercase,msg:''LOGIN Brute Force Password test'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-php'',tag:''platform-multi'',tag:''attack-injection-php'',tag:''OWASP_CRS/WEB_ATTACK/PHP_INJECTION'',tag:''OWASP_TOP_10/A1'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''ddos_burst_time_slice=10,ddos_counter_threshold=3,ddos_block_timeout=60'',setvar:''tx.php_injection_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/PHP_INJECTION-%{MATCHED_VAR_NAME}=%{tx.0}''"', 9, 20, 5, '密码暴力破解');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(9, '密码暴力破解21', 'alert', 'Y', 1, NULL, 'SecRule DDOS "@rx login.asp" "id:21,phase:2,block,capture,t:none,t:urlDecodeUni,t:lowercase,msg:''LOGIN Brute Force Password login.asp'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-php'',tag:''platform-multi'',tag:''attack-injection-php'',tag:''OWASP_CRS/WEB_ATTACK/PHP_INJECTION'',tag:''OWASP_TOP_10/A1'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''ddos_burst_time_slice=10,ddos_counter_threshold=3,ddos_block_timeout=10'',setvar:''tx.php_injection_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/PHP_INJECTION-%{MATCHED_VAR_NAME}=%{tx.0}''"', 9, 21, 5, '密码暴力破解');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(10, 'CC & DDOS攻击22', 'alert', 'Y', 1, NULL, 'SecRule DDOS "!@rx ^.*?\.(jpg|png|js|gif|css)$" "id:22,phase:2,block,capture,t:none,t:urlDecodeUni,t:lowercase,msg:''CC or DDOS attack'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-php'',tag:''platform-multi'',tag:''attack-injection-php'',tag:''OWASP_CRS/WEB_ATTACK/PHP_INJECTION'',tag:''OWASP_TOP_10/A1'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''ddos_burst_time_slice=5,ddos_counter_threshold=200,ddos_block_timeout=60'',setvar:''tx.php_injection_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/PHP_INJECTION-%{MATCHED_VAR_NAME}=%{tx.0}''"', 10, 22, 5, 'CC & DDOS攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(11, '恶意漏洞探测102', 'alert', 'Y', 2, NULL, 'SecRule hihttps "@hihttps machine learning" "id:102,phase:2,block,capture,t:none,t:lowercase,msg:''非法探测，可能为下一步攻击准备'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scanner'',tag:''OWASP_CRS/AUTOMATION/SECURITY_SCANNER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7''"', 11, 102, 5, '恶意漏洞探测');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(12, '恶意漏洞探测101', 'alert', 'Y', 2, NULL, 'SecRule hihttps "@hihttps machine learning" "id:101,phase:2,block,capture,t:none,t:lowercase,msg:''URL黑名单，一律视为攻击'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-reputation-scanner'',tag:''OWASP_CRS/AUTOMATION/SECURITY_SCANNER'',tag:''WASCTC/WASC-21'',tag:''OWASP_TOP_10/A7''" ', 11, 101, 5, '恶意漏洞探测');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(13, '远程执行任意命令漏洞932100', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?:;|\{|\||\|\||&|&&|\n|\r|\$\(|\$\(\(|`|\${|<\(|>\(|\(\s*\))\s*(?:{|\s*\(\s*|\w+=(?:[^\s]*|\$.*|\$.*|<.*|>.*|\''.*\''|\".*\")\s+|!\s*|\$)*\s*(?:''|\")*(?:[\?\*\[\]\(\)\-\|+\w''\"\./\\\\]+/)?[\\\\''\"]*(?:l[\\\\''\"]*(?:w[\\\\''\"]*p[\\\\''\"]*-[\\\\''\"]*(?:d[\\\\''\"]*(?:o[\\\\''\"]*w[\\\\''\"]*n[\\\\''\"]*l[\\\\''\"]*o[\\\\''\"]*a[\\\\''\"]*d|u[\\\\''\"]*m[\\\\''\"]*p)|r[\\\\''\"]*e[\\\\''\"]*q[\\\\''\"]*u[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*t|m[\\\\''\"]*i[\\\\''\"]*r[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*r)|s(?:[\\\\''\"]*(?:b[\\\\''\"]*_[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*l[\\\\''\"]*e[\\\\''\"]*a[\\\\''\"]*s[\\\\''\"]*e|c[\\\\''\"]*p[\\\\''\"]*u|m[\\\\''\"]*o[\\\\''\"]*d|p[\\\\''\"]*c[\\\\''\"]*i|u[\\\\''\"]*s[\\\\''\"]*b|-[\\\\''\"]*F|h[\\\\''\"]*w|o[\\\\''\"]*f))?|z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|m[\\\\''\"]*(?:o[\\\\''\"]*r[\\\\''\"]*e|a)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s)|e[\\\\''\"]*s[\\\\''\"]*s[\\\\''\"]*(?:(?:f[\\\\''\"]*i[\\\\''\"]*l|p[\\\\''\"]*i[\\\\''\"]*p)[\\\\''\"]*e|e[\\\\''\"]*c[\\\\''\"]*h[\\\\''\"]*o|(?:\s|<|>).*)|a[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*(?:l[\\\\''\"]*o[\\\\''\"]*g(?:[\\\\''\"]*i[\\\\''\"]*n)?|c[\\\\''\"]*o[\\\\''\"]*m[\\\\''\"]*m|(?:\s|<|>).*)|o[\\\\''\"]*(?:c[\\\\''\"]*a[\\\\''\"]*(?:t[\\\\''\"]*e|l)[\\\\''\"]*(?:\s|<|>).*|g[\\\\''\"]*n[\\\\''\"]*a[\\\\''\"]*m[\\\\''\"]*e)|d[\\\\''\"]*(?:c[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*f[\\\\''\"]*i[\\\\''\"]*g|d[\\\\''\"]*(?:\s|<|>).*)|f[\\\\''\"]*t[\\\\''\"]*p(?:[\\\\''\"]*g[\\\\''\"]*e[\\\\''\"]*t)?|(?:[np]|y[\\\\''\"]*n[\\\\''\"]*x)[\\\\''\"]*(?:\s|<|>).*)|b[\\\\''\"]*(?:z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e|c[\\\\''\"]*a[\\\\''\"]*t|i[\\\\''\"]*p[\\\\''\"]*2)|s[\\\\''\"]*d[\\\\''\"]*(?:c[\\\\''\"]*a[\\\\''\"]*t|i[\\\\''\"]*f[\\\\''\"]*f|t[\\\\''\"]*a[\\\\''\"]*r)|a[\\\\''\"]*(?:t[\\\\''\"]*c[\\\\''\"]*h[\\\\''\"]*(?:\s|<|>).*|s[\\\\''\"]*h)|r[\\\\''\"]*e[\\\\''\"]*a[\\\\''\"]*k[\\\\''\"]*s[\\\\''\"]*w|u[\\\\''\"]*i[\\\\''\"]*l[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*n)|c[\\\\''\"]*(?:o[\\\\''\"]*(?:m[\\\\''\"]*(?:p[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*a[\\\\''\"]*n[\\\\''\"]*d)[\\\\''\"]*(?:\s|<|>).*|p[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*c)|h[\\\\''\"]*(?:d[\\\\''\"]*i[\\\\''\"]*r[\\\\''\"]*(?:\s|<|>).*|f[\\\\''\"]*l[\\\\''\"]*a[\\\\''\"]*g[\\\\''\"]*s|a[\\\\''\"]*t[\\\\''\"]*t[\\\\''\"]*r|m[\\\\''\"]*o[\\\\''\"]*d)|r[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*t[\\\\''\"]*a[\\\\''\"]*b|(?:[cp]|a[\\\\''\"]*t)[\\\\''\"]*(?:\s|<|>).*|u[\\\\''\"]*r[\\\\''\"]*l|s[\\\\''\"]*h)|f[\\\\''\"]*(?:i(?:[\\\\''\"]*(?:l[\\\\''\"]*e[\\\\''\"]*(?:t[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*t|(?:\s|<|>).*)|n[\\\\''\"]*d[\\\\''\"]*(?:\s|<|>).*))?|t[\\\\''\"]*p[\\\\''\"]*(?:s[\\\\''\"]*t[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*s|w[\\\\''\"]*h[\\\\''\"]*o|(?:\s|<|>).*)|u[\\\\''\"]*n[\\\\''\"]*c[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*o[\\\\''\"]*n|(?:e[\\\\''\"]*t[\\\\''\"]*c[\\\\''\"]*h|c)[\\\\''\"]*(?:\s|<|>).*|o[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*h|g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p)|e[\\\\''\"]*(?:n[\\\\''\"]*(?:v(?:[\\\\''\"]*-[\\\\''\"]*u[\\\\''\"]*p[\\\\''\"]*d[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*e)?|d[\\\\''\"]*(?:i[\\\\''\"]*f|s[\\\\''\"]*w))|x[\\\\''\"]*(?:p[\\\\''\"]*(?:a[\\\\''\"]*n[\\\\''\"]*d|o[\\\\''\"]*r[\\\\''\"]*t|r)|e[\\\\''\"]*c[\\\\''\"]*(?:\s|<|>).*)|c[\\\\''\"]*h[\\\\''\"]*o[\\\\''\"]*(?:\s|<|>).*|g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|s[\\\\''\"]*a[\\\\''\"]*c|v[\\\\''\"]*a[\\\\''\"]*l)|h[\\\\''\"]*(?:t[\\\\''\"]*(?:d[\\\\''\"]*i[\\\\''\"]*g[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*t|p[\\\\''\"]*a[\\\\''\"]*s[\\\\''\"]*s[\\\\''\"]*w[\\\\''\"]*d)|o[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*(?:n[\\\\''\"]*a[\\\\''\"]*m[\\\\''\"]*e|i[\\\\''\"]*d)|(?:e[\\\\''\"]*a[\\\\''\"]*d|u[\\\\''\"]*p)[\\\\''\"]*(?:\s|<|>).*|i[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*y)|i[\\\\''\"]*(?:p[\\\\''\"]*(?:(?:6[\\\\''\"]*)?t[\\\\''\"]*a[\\\\''\"]*b[\\\\''\"]*l[\\\\''\"]*e[\\\\''\"]*s|c[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*f[\\\\''\"]*i[\\\\''\"]*g)|r[\\\\''\"]*b(?:[\\\\''\"]*(?:1(?:[\\\\''\"]*[89])?|2[\\\\''\"]*[012]))?|f[\\\\''\"]*c[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*f[\\\\''\"]*i[\\\\''\"]*g|d[\\\\''\"]*(?:\s|<|>).*)|g[\\\\''\"]*(?:(?:e[\\\\''\"]*t[\\\\''\"]*f[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*l|r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*c|i[\\\\''\"]*t)[\\\\''\"]*(?:\s|<|>).*|z[\\\\''\"]*(?:c[\\\\''\"]*a[\\\\''\"]*t|i[\\\\''\"]*p)|u[\\\\''\"]*n[\\\\''\"]*z[\\\\''\"]*i[\\\\''\"]*p|d[\\\\''\"]*b)|a[\\\\''\"]*(?:(?:l[\\\\''\"]*i[\\\\''\"]*a[\\\\''\"]*s|w[\\\\''\"]*k)[\\\\''\"]*(?:\s|<|>).*|d[\\\\''\"]*d[\\\\''\"]*u[\\\\''\"]*s[\\\\''\"]*e[\\\\''\"]*r|p[\\\\''\"]*t[\\\\''\"]*-[\\\\''\"]*g[\\\\''\"]*e[\\\\''\"]*t|r[\\\\''\"]*(?:c[\\\\''\"]*h[\\\\''\"]*(?:\s|<|>).*|p))|d[\\\\''\"]*(?:h[\\\\''\"]*c[\\\\''\"]*l[\\\\''\"]*i[\\\\''\"]*e[\\\\''\"]*n[\\\\''\"]*t|(?:i[\\\\''\"]*f[\\\\''\"]*f|u)[\\\\''\"]*(?:\s|<|>).*|(?:m[\\\\''\"]*e[\\\\''\"]*s|p[\\\\''\"]*k)[\\\\''\"]*g|o[\\\\''\"]*(?:a[\\\\''\"]*s|n[\\\\''\"]*e)|a[\\\\''\"]*s[\\\\''\"]*h)|m[\\\\''\"]*(?:(?:k[\\\\''\"]*d[\\\\''\"]*i[\\\\''\"]*r|o[\\\\''\"]*r[\\\\''\"]*e)[\\\\''\"]*(?:\s|<|>).*|a[\\\\''\"]*i[\\\\''\"]*l[\\\\''\"]*(?:x[\\\\''\"]*(?:\s|<|>).*|q)|l[\\\\''\"]*o[\\\\''\"]*c[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*e)|j[\\\\''\"]*(?:(?:a[\\\\''\"]*v[\\\\''\"]*a|o[\\\\''\"]*b[\\\\''\"]*s)[\\\\''\"]*(?:\s|<|>).*|e[\\\\''\"]*x[\\\\''\"]*e[\\\\''\"]*c)|k[\\\\''\"]*i[\\\\''\"]*l[\\\\''\"]*l[\\\\''\"]*(?:a[\\\\''\"]*l[\\\\''\"]*l|(?:\s|<|>).*)|(?:G[\\\\''\"]*E[\\\\''\"]*T[\\\\''\"]*(?:\s|<|>)|\.\s).*|7[\\\\''\"]*z(?:[\\\\''\"]*[ar])?)\b" "id:932100,phase:2,block,capture,t:none,msg:''Remote Command Execution: Unix Command Injection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932100, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(14, '远程执行任意命令漏洞932105', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?:;|\{|\||\|\||&|&&|\n|\r|\$\(|\$\(\(|`|\${|<\(|>\(|\(\s*\))\s*(?:{|\s*\(\s*|\w+=(?:[^\s]*|\$.*|\$.*|<.*|>.*|\''.*\''|\".*\")\s+|!\s*|\$)*\s*(?:''|\")*(?:[\?\*\[\]\(\)\-\|+\w''\"\./\\\\]+/)?[\\\\''\"]*(?:s[\\\\''\"]*(?:e[\\\\''\"]*(?:t[\\\\''\"]*(?:(?:f[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*l[\\\\''\"]*)?(?:\s|<|>).*|e[\\\\''\"]*n[\\\\''\"]*v|s[\\\\''\"]*i[\\\\''\"]*d)|n[\\\\''\"]*d[\\\\''\"]*m[\\\\''\"]*a[\\\\''\"]*i[\\\\''\"]*l|d[\\\\''\"]*(?:\s|<|>).*)|h[\\\\''\"]*(?:\.[\\\\''\"]*d[\\\\''\"]*i[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*r[\\\\''\"]*i[\\\\''\"]*b|u[\\\\''\"]*t[\\\\''\"]*d[\\\\''\"]*o[\\\\''\"]*w[\\\\''\"]*n|(?:\s|<|>).*)|o[\\\\''\"]*(?:(?:u[\\\\''\"]*r[\\\\''\"]*c[\\\\''\"]*e|r[\\\\''\"]*t)[\\\\''\"]*(?:\s|<|>).*|c[\\\\''\"]*a[\\\\''\"]*t)|c[\\\\''\"]*(?:h[\\\\''\"]*e[\\\\''\"]*d|p[\\\\''\"]*(?:\s|<|>).*)|t[\\\\''\"]*r[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*g[\\\\''\"]*s|(?:l[\\\\''\"]*e[\\\\''\"]*e|f[\\\\''\"]*t)[\\\\''\"]*p|y[\\\\''\"]*s[\\\\''\"]*c[\\\\''\"]*t[\\\\''\"]*l|u[\\\\''\"]*(?:(?:\s|<|>).*|d[\\\\''\"]*o)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|s[\\\\''\"]*h|v[\\\\''\"]*n)|p[\\\\''\"]*(?:k[\\\\''\"]*(?:g(?:(?:[\\\\''\"]*_)?[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*f[\\\\''\"]*o)?|e[\\\\''\"]*x[\\\\''\"]*e[\\\\''\"]*c|i[\\\\''\"]*l[\\\\''\"]*l)|t[\\\\''\"]*a[\\\\''\"]*r(?:[\\\\''\"]*(?:d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p))?|a[\\\\''\"]*(?:t[\\\\''\"]*c[\\\\''\"]*h[\\\\''\"]*(?:\s|<|>).*|s[\\\\''\"]*s[\\\\''\"]*w[\\\\''\"]*d)|r[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*t[\\\\''\"]*(?:e[\\\\''\"]*n[\\\\''\"]*v|f[\\\\''\"]*(?:\s|<|>).*)|y[\\\\''\"]*t[\\\\''\"]*h[\\\\''\"]*o[\\\\''\"]*n(?:[\\\\''\"]*(?:3(?:[\\\\''\"]*m)?|2))?|e[\\\\''\"]*r[\\\\''\"]*(?:l(?:[\\\\''\"]*(?:s[\\\\''\"]*h|5))?|m[\\\\''\"]*s)|(?:g[\\\\''\"]*r[\\\\''\"]*e|f[\\\\''\"]*t)[\\\\''\"]*p|(?:u[\\\\''\"]*s[\\\\''\"]*h|o[\\\\''\"]*p)[\\\\''\"]*d|h[\\\\''\"]*p(?:[\\\\''\"]*[57])?|i[\\\\''\"]*n[\\\\''\"]*g|s[\\\\''\"]*(?:\s|<|>).*)|n[\\\\''\"]*(?:c[\\\\''\"]*(?:\.[\\\\''\"]*(?:t[\\\\''\"]*r[\\\\''\"]*a[\\\\''\"]*d[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*a[\\\\''\"]*l|o[\\\\''\"]*p[\\\\''\"]*e[\\\\''\"]*n[\\\\''\"]*b[\\\\''\"]*s[\\\\''\"]*d)|(?:\s|<|>).*|a[\\\\''\"]*t)|e[\\\\''\"]*t[\\\\''\"]*(?:k[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*-[\\\\''\"]*f[\\\\''\"]*t[\\\\''\"]*p|(?:s[\\\\''\"]*t|c)[\\\\''\"]*a[\\\\''\"]*t|(?:\s|<|>).*)|s[\\\\''\"]*(?:l[\\\\''\"]*o[\\\\''\"]*o[\\\\''\"]*k[\\\\''\"]*u[\\\\''\"]*p|t[\\\\''\"]*a[\\\\''\"]*t)|(?:a[\\\\''\"]*n[\\\\''\"]*o|i[\\\\''\"]*c[\\\\''\"]*e)[\\\\''\"]*(?:\s|<|>).*|(?:o[\\\\''\"]*h[\\\\''\"]*u|m[\\\\''\"]*a)[\\\\''\"]*p|p[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*g)|r[\\\\''\"]*(?:e[\\\\''\"]*(?:(?:p[\\\\''\"]*(?:l[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e|e[\\\\''\"]*a[\\\\''\"]*t)|n[\\\\''\"]*a[\\\\''\"]*m[\\\\''\"]*e)[\\\\''\"]*(?:\s|<|>).*|a[\\\\''\"]*l[\\\\''\"]*p[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*h)|m[\\\\''\"]*(?:(?:d[\\\\''\"]*i[\\\\''\"]*r[\\\\''\"]*)?(?:\s|<|>).*|u[\\\\''\"]*s[\\\\''\"]*e[\\\\''\"]*r)|u[\\\\''\"]*b[\\\\''\"]*y(?:[\\\\''\"]*(?:1(?:[\\\\''\"]*[89])?|2[\\\\''\"]*[012]))?|(?:a[\\\\''\"]*r|c[\\\\''\"]*p|p[\\\\''\"]*m)[\\\\''\"]*(?:\s|<|>).*|n[\\\\''\"]*a[\\\\''\"]*n[\\\\''\"]*o|o[\\\\''\"]*u[\\\\''\"]*t[\\\\''\"]*e|s[\\\\''\"]*y[\\\\''\"]*n[\\\\''\"]*c)|t[\\\\''\"]*(?:c[\\\\''\"]*(?:p[\\\\''\"]*(?:t[\\\\''\"]*r[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*u[\\\\''\"]*t[\\\\''\"]*e|i[\\\\''\"]*n[\\\\''\"]*g)|s[\\\\''\"]*h)|r[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*u[\\\\''\"]*t[\\\\''\"]*e(?:[\\\\''\"]*6)?|e[\\\\''\"]*(?:l[\\\\''\"]*n[\\\\''\"]*e[\\\\''\"]*t|e[\\\\''\"]*(?:\s|<|>).*)|i[\\\\''\"]*m[\\\\''\"]*e[\\\\''\"]*(?:o[\\\\''\"]*u[\\\\''\"]*t|(?:\s|<|>).*)|a[\\\\''\"]*(?:i[\\\\''\"]*l(?:[\\\\''\"]*f)?|r[\\\\''\"]*(?:\s|<|>).*)|o[\\\\''\"]*(?:u[\\\\''\"]*c[\\\\''\"]*h[\\\\''\"]*(?:\s|<|>).*|p))|u[\\\\''\"]*(?:n[\\\\''\"]*(?:l[\\\\''\"]*(?:i[\\\\''\"]*n[\\\\''\"]*k[\\\\''\"]*(?:\s|<|>).*|z[\\\\''\"]*m[\\\\''\"]*a)|c[\\\\''\"]*o[\\\\''\"]*m[\\\\''\"]*p[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|a[\\\\''\"]*m[\\\\''\"]*e|r[\\\\''\"]*a[\\\\''\"]*r|s[\\\\''\"]*e[\\\\''\"]*t|z[\\\\''\"]*i[\\\\''\"]*p|x[\\\\''\"]*z)|s[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*(?:(?:a[\\\\''\"]*d|m[\\\\''\"]*o)[\\\\''\"]*d|d[\\\\''\"]*e[\\\\''\"]*l)|l[\\\\''\"]*i[\\\\''\"]*m[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*(?:\s|<|>).*)|m[\\\\''\"]*(?:y[\\\\''\"]*s[\\\\''\"]*q[\\\\''\"]*l(?:[\\\\''\"]*(?:d[\\\\''\"]*u[\\\\''\"]*m[\\\\''\"]*p(?:[\\\\''\"]*s[\\\\''\"]*l[\\\\''\"]*o[\\\\''\"]*w)?|h[\\\\''\"]*o[\\\\''\"]*t[\\\\''\"]*c[\\\\''\"]*o[\\\\''\"]*p[\\\\''\"]*y|a[\\\\''\"]*d[\\\\''\"]*m[\\\\''\"]*i[\\\\''\"]*n|s[\\\\''\"]*h[\\\\''\"]*o[\\\\''\"]*w))?|(?:(?:o[\\\\''\"]*u[\\\\''\"]*n|u[\\\\''\"]*t)[\\\\''\"]*t|v)[\\\\''\"]*(?:\s|<|>).*)|x[\\\\''\"]*(?:z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|d[\\\\''\"]*(?:i[\\\\''\"]*f[\\\\''\"]*f|e[\\\\''\"]*c)|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e|(?:\s|<|>).*)|a[\\\\''\"]*r[\\\\''\"]*g[\\\\''\"]*s|t[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*m|x[\\\\''\"]*d[\\\\''\"]*(?:\s|<|>).*)|z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|i[\\\\''\"]*p[\\\\''\"]*(?:\s|<|>).*|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e|r[\\\\''\"]*u[\\\\''\"]*n|s[\\\\''\"]*h)|o[\\\\''\"]*(?:p[\\\\''\"]*e[\\\\''\"]*n[\\\\''\"]*s[\\\\''\"]*s[\\\\''\"]*l|n[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*t[\\\\''\"]*r)|w[\\\\''\"]*(?:h[\\\\''\"]*o[\\\\''\"]*(?:a[\\\\''\"]*m[\\\\''\"]*i|(?:\s|<|>).*)|g[\\\\''\"]*e[\\\\''\"]*t|3[\\\\''\"]*m)|v[\\\\''\"]*i[\\\\''\"]*(?:m[\\\\''\"]*(?:\s|<|>).*|g[\\\\''\"]*r|p[\\\\''\"]*w)|y[\\\\''\"]*u[\\\\''\"]*m)\b" "id:932105,phase:2,block,capture,t:none,msg:''Remote Command Execution: Unix Command Injection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932105, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(15, '远程执行任意命令漏洞932110', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?i)(?:;|\{|\||\|\||&|&&|\n|\r|`)\s*[\(,@\''\"\s]*(?:[\w''\"\./]+/|[\\\\''\"\^]*\w[\\\\''\"\^]*:.*\\\\|[\^\.\w ''\"/\\\\]*\\\\)?[\"\^]*(?:m[\"\^]*(?:y[\"\^]*s[\"\^]*q[\"\^]*l(?:[\"\^]*(?:d[\"\^]*u[\"\^]*m[\"\^]*p(?:[\"\^]*s[\"\^]*l[\"\^]*o[\"\^]*w)?|h[\"\^]*o[\"\^]*t[\"\^]*c[\"\^]*o[\"\^]*p[\"\^]*y|a[\"\^]*d[\"\^]*m[\"\^]*i[\"\^]*n|s[\"\^]*h[\"\^]*o[\"\^]*w))?|s[\"\^]*(?:i[\"\^]*(?:n[\"\^]*f[\"\^]*o[\"\^]*3[\"\^]*2|e[\"\^]*x[\"\^]*e[\"\^]*c)|c[\"\^]*o[\"\^]*n[\"\^]*f[\"\^]*i[\"\^]*g|g[\"\^]*(?:[\s,;]|\.|/|<|>).*|t[\"\^]*s[\"\^]*c)|o[\"\^]*(?:u[\"\^]*n[\"\^]*t[\"\^]*(?:(?:[\s,;]|\.|/|<|>).*|v[\"\^]*o[\"\^]*l)|v[\"\^]*e[\"\^]*u[\"\^]*s[\"\^]*e[\"\^]*r|[dr][\"\^]*e[\"\^]*(?:[\s,;]|\.|/|<|>).*)|k[\"\^]*(?:d[\"\^]*i[\"\^]*r[\"\^]*(?:[\s,;]|\.|/|<|>).*|l[\"\^]*i[\"\^]*n[\"\^]*k)|d[\"\^]*(?:s[\"\^]*c[\"\^]*h[\"\^]*e[\"\^]*d|(?:[\s,;]|\.|/|<|>).*)|a[\"\^]*p[\"\^]*i[\"\^]*s[\"\^]*e[\"\^]*n[\"\^]*d|b[\"\^]*s[\"\^]*a[\"\^]*c[\"\^]*l[\"\^]*i|e[\"\^]*a[\"\^]*s[\"\^]*u[\"\^]*r[\"\^]*e|m[\"\^]*s[\"\^]*y[\"\^]*s)|d[\"\^]*(?:i[\"\^]*(?:s[\"\^]*k[\"\^]*(?:(?:m[\"\^]*g[\"\^]*m|p[\"\^]*a[\"\^]*r)[\"\^]*t|s[\"\^]*h[\"\^]*a[\"\^]*d[\"\^]*o[\"\^]*w)|r[\"\^]*(?:(?:[\s,;]|\.|/|<|>).*|u[\"\^]*s[\"\^]*e)|f[\"\^]*f[\"\^]*(?:[\s,;]|\.|/|<|>).*)|e[\"\^]*(?:l[\"\^]*(?:p[\"\^]*r[\"\^]*o[\"\^]*f|t[\"\^]*r[\"\^]*e[\"\^]*e|(?:[\s,;]|\.|/|<|>).*)|v[\"\^]*(?:m[\"\^]*g[\"\^]*m[\"\^]*t|c[\"\^]*o[\"\^]*n)|(?:f[\"\^]*r[\"\^]*a|b[\"\^]*u)[\"\^]*g)|s[\"\^]*(?:a[\"\^]*(?:c[\"\^]*l[\"\^]*s|d[\"\^]*d)|q[\"\^]*u[\"\^]*e[\"\^]*r[\"\^]*y|m[\"\^]*o[\"\^]*(?:v[\"\^]*e|d)|g[\"\^]*e[\"\^]*t|r[\"\^]*m)|(?:r[\"\^]*i[\"\^]*v[\"\^]*e[\"\^]*r[\"\^]*q[\"\^]*u[\"\^]*e[\"\^]*r|o[\"\^]*s[\"\^]*k[\"\^]*e)[\"\^]*y|(?:c[\"\^]*o[\"\^]*m[\"\^]*c[\"\^]*n[\"\^]*f|x[\"\^]*d[\"\^]*i[\"\^]*a)[\"\^]*g|a[\"\^]*t[\"\^]*e[\"\^]*(?:[\s,;]|\.|/|<|>).*|n[\"\^]*s[\"\^]*s[\"\^]*t[\"\^]*a[\"\^]*t)|c[\"\^]*(?:o[\"\^]*(?:m[\"\^]*(?:p[\"\^]*(?:(?:a[\"\^]*c[\"\^]*t[\"\^]*)?(?:[\s,;]|\.|/|<|>).*|m[\"\^]*g[\"\^]*m[\"\^]*t)|e[\"\^]*x[\"\^]*p)|n[\"\^]*(?:2[\"\^]*p|v[\"\^]*e)[\"\^]*r[\"\^]*t|p[\"\^]*y)|l[\"\^]*(?:e[\"\^]*a[\"\^]*(?:n[\"\^]*m[\"\^]*g[\"\^]*r|r[\"\^]*m[\"\^]*e[\"\^]*m)|u[\"\^]*s[\"\^]*t[\"\^]*e[\"\^]*r)|h[\"\^]*(?:k[\"\^]*(?:n[\"\^]*t[\"\^]*f[\"\^]*s|d[\"\^]*s[\"\^]*k)|d[\"\^]*i[\"\^]*r[\"\^]*(?:[\s,;]|\.|/|<|>).*)|s[\"\^]*(?:c[\"\^]*(?:r[\"\^]*i[\"\^]*p[\"\^]*t|c[\"\^]*m[\"\^]*d)|v[\"\^]*d[\"\^]*e)|e[\"\^]*r[\"\^]*t[\"\^]*(?:u[\"\^]*t[\"\^]*i[\"\^]*l|r[\"\^]*e[\"\^]*q)|a[\"\^]*(?:l[\"\^]*l[\"\^]*(?:[\s,;]|\.|/|<|>).*|c[\"\^]*l[\"\^]*s)|m[\"\^]*d(?:[\"\^]*k[\"\^]*e[\"\^]*y)?|i[\"\^]*p[\"\^]*h[\"\^]*e[\"\^]*r|u[\"\^]*r[\"\^]*l)|f[\"\^]*(?:o[\"\^]*r[\"\^]*(?:m[\"\^]*a[\"\^]*t[\"\^]*(?:[\s,;]|\.|/|<|>).*|f[\"\^]*i[\"\^]*l[\"\^]*e[\"\^]*s|e[\"\^]*a[\"\^]*c[\"\^]*h)|i[\"\^]*n[\"\^]*d[\"\^]*(?:(?:[\s,;]|\.|/|<|>).*|s[\"\^]*t[\"\^]*r)|s[\"\^]*(?:m[\"\^]*g[\"\^]*m[\"\^]*t|u[\"\^]*t[\"\^]*i[\"\^]*l)|t[\"\^]*(?:p[\"\^]*(?:[\s,;]|\.|/|<|>).*|y[\"\^]*p[\"\^]*e)|r[\"\^]*e[\"\^]*e[\"\^]*d[\"\^]*i[\"\^]*s[\"\^]*k|c[\"\^]*(?:[\s,;]|\.|/|<|>).*|g[\"\^]*r[\"\^]*e[\"\^]*p)|n[\"\^]*(?:e[\"\^]*t[\"\^]*(?:s[\"\^]*(?:t[\"\^]*a[\"\^]*t|v[\"\^]*c|h)|(?:[\s,;]|\.|/|<|>).*|c[\"\^]*a[\"\^]*t|d[\"\^]*o[\"\^]*m)|t[\"\^]*(?:b[\"\^]*a[\"\^]*c[\"\^]*k[\"\^]*u[\"\^]*p|r[\"\^]*i[\"\^]*g[\"\^]*h[\"\^]*t[\"\^]*s)|(?:s[\"\^]*l[\"\^]*o[\"\^]*o[\"\^]*k[\"\^]*u|m[\"\^]*a)[\"\^]*p|c[\"\^]*(?:(?:[\s,;]|\.|/|<|>).*|a[\"\^]*t)|b[\"\^]*t[\"\^]*s[\"\^]*t[\"\^]*a[\"\^]*t)|e[\"\^]*(?:x[\"\^]*p[\"\^]*(?:a[\"\^]*n[\"\^]*d[\"\^]*(?:[\s,;]|\.|/|<|>).*|l[\"\^]*o[\"\^]*r[\"\^]*e[\"\^]*r)|v[\"\^]*e[\"\^]*n[\"\^]*t[\"\^]*(?:c[\"\^]*r[\"\^]*e[\"\^]*a[\"\^]*t[\"\^]*e|v[\"\^]*w[\"\^]*r)|n[\"\^]*d[\"\^]*l[\"\^]*o[\"\^]*c[\"\^]*a[\"\^]*l|g[\"\^]*r[\"\^]*e[\"\^]*p|r[\"\^]*a[\"\^]*s[\"\^]*e|c[\"\^]*h[\"\^]*o)|g[\"\^]*(?:a[\"\^]*t[\"\^]*h[\"\^]*e[\"\^]*r[\"\^]*n[\"\^]*e[\"\^]*t[\"\^]*w[\"\^]*o[\"\^]*r[\"\^]*k[\"\^]*i[\"\^]*n[\"\^]*f[\"\^]*o|p[\"\^]*(?:(?:r[\"\^]*e[\"\^]*s[\"\^]*u[\"\^]*l|e[\"\^]*d[\"\^]*i)[\"\^]*t|u[\"\^]*p[\"\^]*d[\"\^]*a[\"\^]*t[\"\^]*e)|i[\"\^]*t[\"\^]*(?:[\s,;]|\.|/|<|>).*|e[\"\^]*t[\"\^]*m[\"\^]*a[\"\^]*c)|i[\"\^]*(?:r[\"\^]*b(?:[\"\^]*(?:1(?:[\"\^]*[89])?|2[\"\^]*[012]))?|f[\"\^]*m[\"\^]*e[\"\^]*m[\"\^]*b[\"\^]*e[\"\^]*r|p[\"\^]*c[\"\^]*o[\"\^]*n[\"\^]*f[\"\^]*i[\"\^]*g|n[\"\^]*e[\"\^]*t[\"\^]*c[\"\^]*p[\"\^]*l|c[\"\^]*a[\"\^]*c[\"\^]*l[\"\^]*s)|a[\"\^]*(?:d[\"\^]*(?:d[\"\^]*u[\"\^]*s[\"\^]*e[\"\^]*r[\"\^]*s|m[\"\^]*o[\"\^]*d[\"\^]*c[\"\^]*m[\"\^]*d)|r[\"\^]*p[\"\^]*(?:[\s,;]|\.|/|<|>).*|t[\"\^]*t[\"\^]*r[\"\^]*i[\"\^]*b|s[\"\^]*s[\"\^]*o[\"\^]*c|z[\"\^]*m[\"\^]*a[\"\^]*n)|l[\"\^]*(?:o[\"\^]*g[\"\^]*(?:e[\"\^]*v[\"\^]*e[\"\^]*n[\"\^]*t|t[\"\^]*i[\"\^]*m[\"\^]*e|m[\"\^]*a[\"\^]*n|o[\"\^]*f[\"\^]*f)|a[\"\^]*b[\"\^]*e[\"\^]*l[\"\^]*(?:[\s,;]|\.|/|<|>).*|u[\"\^]*s[\"\^]*r[\"\^]*m[\"\^]*g[\"\^]*r)|b[\"\^]*(?:(?:c[\"\^]*d[\"\^]*(?:b[\"\^]*o[\"\^]*o|e[\"\^]*d[\"\^]*i)|r[\"\^]*o[\"\^]*w[\"\^]*s[\"\^]*t[\"\^]*a)[\"\^]*t|i[\"\^]*t[\"\^]*s[\"\^]*a[\"\^]*d[\"\^]*m[\"\^]*i[\"\^]*n|o[\"\^]*o[\"\^]*t[\"\^]*c[\"\^]*f[\"\^]*g)|h[\"\^]*(?:o[\"\^]*s[\"\^]*t[\"\^]*n[\"\^]*a[\"\^]*m[\"\^]*e|d[\"\^]*w[\"\^]*w[\"\^]*i[\"\^]*z)|j[\"\^]*a[\"\^]*v[\"\^]*a[\"\^]*(?:[\s,;]|\.|/|<|>).*|7[\"\^]*z(?:[\"\^]*[ar])?)(?:\.[\"\^]*\w+)?\b" "id:932110,phase:2,block,capture,t:none,msg:''Remote Command Execution: Windows Command Injection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-windows'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932110, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(16, '远程执行任意命令漏洞932115', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?i)(?:;|\{|\||\|\||&|&&|\n|\r|`)\s*[\(,@\''\"\s]*(?:[\w''\"\./]+/|[\\\\''\"\^]*\w[\\\\''\"\^]*:.*\\\\|[\^\.\w ''\"/\\\\]*\\\\)?[\"\^]*(?:s[\"\^]*(?:y[\"\^]*s[\"\^]*(?:t[\"\^]*e[\"\^]*m[\"\^]*(?:p[\"\^]*r[\"\^]*o[\"\^]*p[\"\^]*e[\"\^]*r[\"\^]*t[\"\^]*i[\"\^]*e[\"\^]*s[\"\^]*(?:d[\"\^]*a[\"\^]*t[\"\^]*a[\"\^]*e[\"\^]*x[\"\^]*e[\"\^]*c[\"\^]*u[\"\^]*t[\"\^]*i[\"\^]*o[\"\^]*n[\"\^]*p[\"\^]*r[\"\^]*e[\"\^]*v[\"\^]*e[\"\^]*n[\"\^]*t[\"\^]*i[\"\^]*o[\"\^]*n|(?:p[\"\^]*e[\"\^]*r[\"\^]*f[\"\^]*o[\"\^]*r[\"\^]*m[\"\^]*a[\"\^]*n[\"\^]*c|h[\"\^]*a[\"\^]*r[\"\^]*d[\"\^]*w[\"\^]*a[\"\^]*r)[\"\^]*e|a[\"\^]*d[\"\^]*v[\"\^]*a[\"\^]*n[\"\^]*c[\"\^]*e[\"\^]*d)|i[\"\^]*n[\"\^]*f[\"\^]*o)|k[\"\^]*e[\"\^]*y|d[\"\^]*m)|h[\"\^]*(?:o[\"\^]*(?:w[\"\^]*(?:g[\"\^]*r[\"\^]*p|m[\"\^]*b[\"\^]*r)[\"\^]*s|r[\"\^]*t[\"\^]*c[\"\^]*u[\"\^]*t)|e[\"\^]*l[\"\^]*l[\"\^]*r[\"\^]*u[\"\^]*n[\"\^]*a[\"\^]*s|u[\"\^]*t[\"\^]*d[\"\^]*o[\"\^]*w[\"\^]*n|r[\"\^]*p[\"\^]*u[\"\^]*b[\"\^]*w|a[\"\^]*r[\"\^]*e|i[\"\^]*f[\"\^]*t)|e[\"\^]*(?:t[\"\^]*(?:(?:x[\"\^]*)?(?:[\s,;]|\.|/|<|>).*|l[\"\^]*o[\"\^]*c[\"\^]*a[\"\^]*l)|c[\"\^]*p[\"\^]*o[\"\^]*l|l[\"\^]*e[\"\^]*c[\"\^]*t)|c[\"\^]*(?:h[\"\^]*t[\"\^]*a[\"\^]*s[\"\^]*k[\"\^]*s|l[\"\^]*i[\"\^]*s[\"\^]*t)|u[\"\^]*b[\"\^]*(?:i[\"\^]*n[\"\^]*a[\"\^]*c[\"\^]*l|s[\"\^]*t)|t[\"\^]*a[\"\^]*r[\"\^]*t[\"\^]*(?:[\s,;]|\.|/|<|>).*|i[\"\^]*g[\"\^]*v[\"\^]*e[\"\^]*r[\"\^]*i[\"\^]*f|l[\"\^]*(?:e[\"\^]*e[\"\^]*p|m[\"\^]*g[\"\^]*r)|o[\"\^]*r[\"\^]*t|f[\"\^]*c|v[\"\^]*n)|p[\"\^]*(?:s[\"\^]*(?:s[\"\^]*(?:h[\"\^]*u[\"\^]*t[\"\^]*d[\"\^]*o[\"\^]*w[\"\^]*n|e[\"\^]*r[\"\^]*v[\"\^]*i[\"\^]*c[\"\^]*e|u[\"\^]*s[\"\^]*p[\"\^]*e[\"\^]*n[\"\^]*d)|l[\"\^]*(?:o[\"\^]*g[\"\^]*(?:g[\"\^]*e[\"\^]*d[\"\^]*o[\"\^]*n|l[\"\^]*i[\"\^]*s[\"\^]*t)|i[\"\^]*s[\"\^]*t)|p[\"\^]*(?:a[\"\^]*s[\"\^]*s[\"\^]*w[\"\^]*d|i[\"\^]*n[\"\^]*g)|g[\"\^]*e[\"\^]*t[\"\^]*s[\"\^]*i[\"\^]*d|e[\"\^]*x[\"\^]*e[\"\^]*c|f[\"\^]*i[\"\^]*l[\"\^]*e|i[\"\^]*n[\"\^]*f[\"\^]*o|k[\"\^]*i[\"\^]*l[\"\^]*l)|o[\"\^]*(?:w[\"\^]*e[\"\^]*r[\"\^]*(?:s[\"\^]*h[\"\^]*e[\"\^]*l[\"\^]*l(?:[\"\^]*_[\"\^]*i[\"\^]*s[\"\^]*e)?|c[\"\^]*f[\"\^]*g)|r[\"\^]*t[\"\^]*q[\"\^]*r[\"\^]*y|p[\"\^]*d)|r[\"\^]*(?:i[\"\^]*n[\"\^]*t[\"\^]*(?:(?:[\s,;]|\.|/|<|>).*|b[\"\^]*r[\"\^]*m)|n[\"\^]*(?:c[\"\^]*n[\"\^]*f[\"\^]*g|m[\"\^]*n[\"\^]*g[\"\^]*r)|o[\"\^]*m[\"\^]*p[\"\^]*t)|a[\"\^]*t[\"\^]*h[\"\^]*(?:p[\"\^]*i[\"\^]*n[\"\^]*g|(?:[\s,;]|\.|/|<|>).*)|e[\"\^]*r[\"\^]*(?:l(?:[\"\^]*(?:s[\"\^]*h|5))?|f[\"\^]*m[\"\^]*o[\"\^]*n)|y[\"\^]*t[\"\^]*h[\"\^]*o[\"\^]*n(?:[\"\^]*(?:3(?:[\"\^]*m)?|2))?|k[\"\^]*g[\"\^]*m[\"\^]*g[\"\^]*r|h[\"\^]*p(?:[\"\^]*[57])?|u[\"\^]*s[\"\^]*h[\"\^]*d|i[\"\^]*n[\"\^]*g)|r[\"\^]*(?:e[\"\^]*(?:(?:p[\"\^]*l[\"\^]*a[\"\^]*c[\"\^]*e|n(?:[\"\^]*a[\"\^]*m[\"\^]*e)?|s[\"\^]*e[\"\^]*t)[\"\^]*(?:[\s,;]|\.|/|<|>).*|g[\"\^]*(?:s[\"\^]*v[\"\^]*r[\"\^]*3[\"\^]*2|e[\"\^]*d[\"\^]*i[\"\^]*t|(?:[\s,;]|\.|/|<|>).*|i[\"\^]*n[\"\^]*i)|c[\"\^]*(?:d[\"\^]*i[\"\^]*s[\"\^]*c|o[\"\^]*v[\"\^]*e[\"\^]*r)|k[\"\^]*e[\"\^]*y[\"\^]*w[\"\^]*i[\"\^]*z)|u[\"\^]*(?:n[\"\^]*(?:d[\"\^]*l[\"\^]*l[\"\^]*3[\"\^]*2|a[\"\^]*s)|b[\"\^]*y[\"\^]*(?:1(?:[\"\^]*[89])?|2[\"\^]*[012]))|a[\"\^]*(?:s[\"\^]*(?:p[\"\^]*h[\"\^]*o[\"\^]*n[\"\^]*e|d[\"\^]*i[\"\^]*a[\"\^]*l)|r[\"\^]*(?:[\s,;]|\.|/|<|>).*)|m[\"\^]*(?:(?:d[\"\^]*i[\"\^]*r[\"\^]*)?(?:[\s,;]|\.|/|<|>).*|t[\"\^]*s[\"\^]*h[\"\^]*a[\"\^]*r[\"\^]*e)|o[\"\^]*(?:u[\"\^]*t[\"\^]*e[\"\^]*(?:[\s,;]|\.|/|<|>).*|b[\"\^]*o[\"\^]*c[\"\^]*o[\"\^]*p[\"\^]*y)|s[\"\^]*(?:t[\"\^]*r[\"\^]*u[\"\^]*i|y[\"\^]*n[\"\^]*c)|d[\"\^]*(?:[\s,;]|\.|/|<|>).*)|t[\"\^]*(?:a[\"\^]*(?:s[\"\^]*k[\"\^]*(?:k[\"\^]*i[\"\^]*l[\"\^]*l|l[\"\^]*i[\"\^]*s[\"\^]*t|s[\"\^]*c[\"\^]*h[\"\^]*d|m[\"\^]*g[\"\^]*r)|k[\"\^]*e[\"\^]*o[\"\^]*w[\"\^]*n)|(?:i[\"\^]*m[\"\^]*e[\"\^]*o[\"\^]*u|p[\"\^]*m[\"\^]*i[\"\^]*n[\"\^]*i|e[\"\^]*l[\"\^]*n[\"\^]*e|l[\"\^]*i[\"\^]*s)[\"\^]*t|s[\"\^]*(?:d[\"\^]*i[\"\^]*s[\"\^]*c[\"\^]*o|s[\"\^]*h[\"\^]*u[\"\^]*t[\"\^]*d)[\"\^]*n|y[\"\^]*p[\"\^]*e[\"\^]*(?:p[\"\^]*e[\"\^]*r[\"\^]*f|(?:[\s,;]|\.|/|<|>).*)|r[\"\^]*(?:a[\"\^]*c[\"\^]*e[\"\^]*r[\"\^]*t|e[\"\^]*e))|w[\"\^]*(?:i[\"\^]*n[\"\^]*(?:d[\"\^]*i[\"\^]*f[\"\^]*f|m[\"\^]*s[\"\^]*d[\"\^]*p|v[\"\^]*a[\"\^]*r|r[\"\^]*[ms])|u[\"\^]*(?:a[\"\^]*(?:u[\"\^]*c[\"\^]*l[\"\^]*t|p[\"\^]*p)|s[\"\^]*a)|s[\"\^]*c[\"\^]*(?:r[\"\^]*i[\"\^]*p[\"\^]*t|u[\"\^]*i)|e[\"\^]*v[\"\^]*t[\"\^]*u[\"\^]*t[\"\^]*i[\"\^]*l|m[\"\^]*i[\"\^]*(?:m[\"\^]*g[\"\^]*m[\"\^]*t|c)|a[\"\^]*i[\"\^]*t[\"\^]*f[\"\^]*o[\"\^]*r|h[\"\^]*o[\"\^]*a[\"\^]*m[\"\^]*i|g[\"\^]*e[\"\^]*t)|u[\"\^]*(?:s[\"\^]*(?:e[\"\^]*r[\"\^]*a[\"\^]*c[\"\^]*c[\"\^]*o[\"\^]*u[\"\^]*n[\"\^]*t[\"\^]*c[\"\^]*o[\"\^]*n[\"\^]*t[\"\^]*r[\"\^]*o[\"\^]*l[\"\^]*s[\"\^]*e[\"\^]*t[\"\^]*t[\"\^]*i[\"\^]*n[\"\^]*g[\"\^]*s|r[\"\^]*s[\"\^]*t[\"\^]*a[\"\^]*t)|n[\"\^]*(?:r[\"\^]*a[\"\^]*r|z[\"\^]*i[\"\^]*p))|q[\"\^]*(?:u[\"\^]*e[\"\^]*r[\"\^]*y[\"\^]*(?:[\s,;]|\.|/|<|>).*|p[\"\^]*r[\"\^]*o[\"\^]*c[\"\^]*e[\"\^]*s[\"\^]*s|w[\"\^]*i[\"\^]*n[\"\^]*s[\"\^]*t[\"\^]*a|g[\"\^]*r[\"\^]*e[\"\^]*p)|o[\"\^]*(?:d[\"\^]*b[\"\^]*c[\"\^]*(?:a[\"\^]*d[\"\^]*3[\"\^]*2|c[\"\^]*o[\"\^]*n[\"\^]*f)|p[\"\^]*e[\"\^]*n[\"\^]*f[\"\^]*i[\"\^]*l[\"\^]*e[\"\^]*s)|v[\"\^]*(?:o[\"\^]*l[\"\^]*(?:[\s,;]|\.|/|<|>).*|e[\"\^]*r[\"\^]*i[\"\^]*f[\"\^]*y)|x[\"\^]*c[\"\^]*(?:a[\"\^]*c[\"\^]*l[\"\^]*s|o[\"\^]*p[\"\^]*y)|z[\"\^]*i[\"\^]*p[\"\^]*(?:[\s,;]|\.|/|<|>).*)(?:\.[\"\^]*\w+)?\b" "id:932115,phase:2,block,capture,t:none,msg:''Remote Command Execution: Windows Command Injection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-windows'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932115, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(17, '远程执行任意命令漏洞932120', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@pmf windows-powershell-commands.data" "id:932120,phase:2,block,capture,t:none,t:urlDecodeUni,t:cmdLine,t:lowercase,msg:''Remote Command Execution: Windows PowerShell Command Found'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''language-powershell'',tag:''platform-windows'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932120, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(18, '远程执行任意命令漏洞932130', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?:\$(?:\((?:\(.*\)|.*)\)|\{.*\})|[<>]\(.*\))" "id:932130,phase:2,block,capture,t:none,t:urlDecodeUni,t:cmdLine,msg:''Remote Command Execution: Unix Shell Expression Found'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932130, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(19, '远程执行任意命令漏洞932140', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx \b(?:if(?:/i)?(?: not)?(?: exist\b| defined\b| errorlevel\b| cmdextversion\b|(?: |\().*(?:\bgeq\b|\bequ\b|\bneq\b|\bleq\b|\bgtr\b|\blss\b|==))|for(/[dflr].*)* %+[^ ]+ in\(.*\)\s?do)" "id:932140,phase:2,block,capture,t:none,t:urlDecodeUni,t:cmdLine,msg:''Remote Command Execution: Windows FOR/IF Command Found'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-windows'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932140, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(20, '远程执行任意命令漏洞932150', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?:^|=)\s*(?:{|\s*\(\s*|\w+=(?:[^\s]*|\$.*|\$.*|<.*|>.*|\''.*\''|\".*\")\s+|!\s*|\$)*\s*(?:''|\")*(?:[\?\*\[\]\(\)\-\|+\w''\"\./\\\\]+/)?[\\\\''\"]*(?:l[\\\\''\"]*(?:s(?:[\\\\''\"]*(?:b[\\\\''\"]*_[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*l[\\\\''\"]*e[\\\\''\"]*a[\\\\''\"]*s[\\\\''\"]*e|c[\\\\''\"]*p[\\\\''\"]*u|m[\\\\''\"]*o[\\\\''\"]*d|p[\\\\''\"]*c[\\\\''\"]*i|u[\\\\''\"]*s[\\\\''\"]*b|-[\\\\''\"]*F|o[\\\\''\"]*f))?|z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|m[\\\\''\"]*(?:o[\\\\''\"]*r[\\\\''\"]*e|a)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s)|e[\\\\''\"]*s[\\\\''\"]*s[\\\\''\"]*(?:(?:f[\\\\''\"]*i[\\\\''\"]*l|p[\\\\''\"]*i[\\\\''\"]*p)[\\\\''\"]*e|e[\\\\''\"]*c[\\\\''\"]*h[\\\\''\"]*o)|a[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*(?:l[\\\\''\"]*o[\\\\''\"]*g(?:[\\\\''\"]*i[\\\\''\"]*n)?|c[\\\\''\"]*o[\\\\''\"]*m[\\\\''\"]*m)|w[\\\\''\"]*p(?:[\\\\''\"]*-[\\\\''\"]*d[\\\\''\"]*o[\\\\''\"]*w[\\\\''\"]*n[\\\\''\"]*l[\\\\''\"]*o[\\\\''\"]*a[\\\\''\"]*d)?|f[\\\\''\"]*t[\\\\''\"]*p(?:[\\\\''\"]*g[\\\\''\"]*e[\\\\''\"]*t)?|y[\\\\''\"]*n[\\\\''\"]*x)|s[\\\\''\"]*(?:e[\\\\''\"]*(?:t[\\\\''\"]*(?:e[\\\\''\"]*n[\\\\''\"]*v|s[\\\\''\"]*i[\\\\''\"]*d)|n[\\\\''\"]*d[\\\\''\"]*m[\\\\''\"]*a[\\\\''\"]*i[\\\\''\"]*l|d)|h(?:[\\\\''\"]*\.[\\\\''\"]*d[\\\\''\"]*i[\\\\''\"]*s[\\\\''\"]*t[\\\\''\"]*r[\\\\''\"]*i[\\\\''\"]*b)?|o[\\\\''\"]*(?:u[\\\\''\"]*r[\\\\''\"]*c[\\\\''\"]*e|c[\\\\''\"]*a[\\\\''\"]*t)|t[\\\\''\"]*r[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*g[\\\\''\"]*s|y[\\\\''\"]*s[\\\\''\"]*c[\\\\''\"]*t[\\\\''\"]*l|c[\\\\''\"]*(?:h[\\\\''\"]*e[\\\\''\"]*d|p)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|f[\\\\''\"]*t[\\\\''\"]*p|u[\\\\''\"]*d[\\\\''\"]*o|s[\\\\''\"]*h|v[\\\\''\"]*n)|p[\\\\''\"]*(?:t[\\\\''\"]*a[\\\\''\"]*r(?:[\\\\''\"]*(?:d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p))?|y[\\\\''\"]*t[\\\\''\"]*h[\\\\''\"]*o[\\\\''\"]*n(?:[\\\\''\"]*(?:3(?:[\\\\''\"]*m)?|2))?|k[\\\\''\"]*(?:e[\\\\''\"]*x[\\\\''\"]*e[\\\\''\"]*c|i[\\\\''\"]*l[\\\\''\"]*l)|r[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*t[\\\\''\"]*e[\\\\''\"]*n[\\\\''\"]*v|(?:g[\\\\''\"]*r[\\\\''\"]*e|f[\\\\''\"]*t)[\\\\''\"]*p|e[\\\\''\"]*r[\\\\''\"]*l(?:[\\\\''\"]*5)?|h[\\\\''\"]*p(?:[\\\\''\"]*[57])?|i[\\\\''\"]*n[\\\\''\"]*g|o[\\\\''\"]*p[\\\\''\"]*d)|n[\\\\''\"]*(?:c(?:[\\\\''\"]*(?:\.[\\\\''\"]*(?:t[\\\\''\"]*r[\\\\''\"]*a[\\\\''\"]*d[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*o[\\\\''\"]*n[\\\\''\"]*a[\\\\''\"]*l|o[\\\\''\"]*p[\\\\''\"]*e[\\\\''\"]*n[\\\\''\"]*b[\\\\''\"]*s[\\\\''\"]*d)|a[\\\\''\"]*t))?|e[\\\\''\"]*t[\\\\''\"]*(?:k[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*-[\\\\''\"]*f[\\\\''\"]*t[\\\\''\"]*p|(?:s[\\\\''\"]*t|c)[\\\\''\"]*a[\\\\''\"]*t)|o[\\\\''\"]*h[\\\\''\"]*u[\\\\''\"]*p|p[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*g|s[\\\\''\"]*t[\\\\''\"]*a[\\\\''\"]*t)|t[\\\\''\"]*(?:c[\\\\''\"]*(?:p[\\\\''\"]*(?:t[\\\\''\"]*r[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*u[\\\\''\"]*t[\\\\''\"]*e|i[\\\\''\"]*n[\\\\''\"]*g)|s[\\\\''\"]*h)|r[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*u[\\\\''\"]*t[\\\\''\"]*e(?:[\\\\''\"]*6)?|i[\\\\''\"]*m[\\\\''\"]*e(?:[\\\\''\"]*o[\\\\''\"]*u[\\\\''\"]*t)?|a[\\\\''\"]*(?:i[\\\\''\"]*l(?:[\\\\''\"]*f)?|r)|e[\\\\''\"]*l[\\\\''\"]*n[\\\\''\"]*e[\\\\''\"]*t)|r[\\\\''\"]*(?:e[\\\\''\"]*(?:p[\\\\''\"]*(?:l[\\\\''\"]*a[\\\\''\"]*c[\\\\''\"]*e|e[\\\\''\"]*a[\\\\''\"]*t)|a[\\\\''\"]*l[\\\\''\"]*p[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*h|n[\\\\''\"]*a[\\\\''\"]*m[\\\\''\"]*e)|u[\\\\''\"]*b[\\\\''\"]*y(?:[\\\\''\"]*(?:1(?:[\\\\''\"]*[89])?|2[\\\\''\"]*[012]))?|m[\\\\''\"]*(?:u[\\\\''\"]*s[\\\\''\"]*e|d[\\\\''\"]*i)[\\\\''\"]*r|n[\\\\''\"]*a[\\\\''\"]*n[\\\\''\"]*o|s[\\\\''\"]*y[\\\\''\"]*n[\\\\''\"]*c|c[\\\\''\"]*p)|b[\\\\''\"]*(?:z[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e|c[\\\\''\"]*a[\\\\''\"]*t)|s[\\\\''\"]*d[\\\\''\"]*(?:c[\\\\''\"]*a[\\\\''\"]*t|i[\\\\''\"]*f[\\\\''\"]*f|t[\\\\''\"]*a[\\\\''\"]*r)|u[\\\\''\"]*i[\\\\''\"]*l[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*n|a[\\\\''\"]*s[\\\\''\"]*h)|m[\\\\''\"]*(?:y[\\\\''\"]*s[\\\\''\"]*q[\\\\''\"]*l[\\\\''\"]*(?:d[\\\\''\"]*u[\\\\''\"]*m[\\\\''\"]*p(?:[\\\\''\"]*s[\\\\''\"]*l[\\\\''\"]*o[\\\\''\"]*w)?|h[\\\\''\"]*o[\\\\''\"]*t[\\\\''\"]*c[\\\\''\"]*o[\\\\''\"]*p[\\\\''\"]*y|a[\\\\''\"]*d[\\\\''\"]*m[\\\\''\"]*i[\\\\''\"]*n|s[\\\\''\"]*h[\\\\''\"]*o[\\\\''\"]*w)|l[\\\\''\"]*o[\\\\''\"]*c[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*e|a[\\\\''\"]*i[\\\\''\"]*l[\\\\''\"]*q)|u[\\\\''\"]*(?:n[\\\\''\"]*(?:c[\\\\''\"]*o[\\\\''\"]*m[\\\\''\"]*p[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|l[\\\\''\"]*z[\\\\''\"]*m[\\\\''\"]*a|a[\\\\''\"]*m[\\\\''\"]*e|r[\\\\''\"]*a[\\\\''\"]*r|s[\\\\''\"]*e[\\\\''\"]*t|z[\\\\''\"]*i[\\\\''\"]*p|x[\\\\''\"]*z)|s[\\\\''\"]*e[\\\\''\"]*r[\\\\''\"]*(?:(?:a[\\\\''\"]*d|m[\\\\''\"]*o)[\\\\''\"]*d|d[\\\\''\"]*e[\\\\''\"]*l))|x[\\\\''\"]*(?:z(?:[\\\\''\"]*(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|d[\\\\''\"]*(?:i[\\\\''\"]*f[\\\\''\"]*f|e[\\\\''\"]*c)|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e))?|a[\\\\''\"]*r[\\\\''\"]*g[\\\\''\"]*s)|z[\\\\''\"]*(?:(?:(?:[ef][\\\\''\"]*)?g[\\\\''\"]*r[\\\\''\"]*e|i)[\\\\''\"]*p|c[\\\\''\"]*(?:a[\\\\''\"]*t|m[\\\\''\"]*p)|d[\\\\''\"]*i[\\\\''\"]*f[\\\\''\"]*f|l[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*s|m[\\\\''\"]*o[\\\\''\"]*r[\\\\''\"]*e|r[\\\\''\"]*u[\\\\''\"]*n|s[\\\\''\"]*h)|f[\\\\''\"]*(?:t[\\\\''\"]*p[\\\\''\"]*(?:s[\\\\''\"]*t[\\\\''\"]*a[\\\\''\"]*t[\\\\''\"]*s|w[\\\\''\"]*h[\\\\''\"]*o)|i[\\\\''\"]*l[\\\\''\"]*e[\\\\''\"]*t[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*t|e[\\\\''\"]*t[\\\\''\"]*c[\\\\''\"]*h|g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p)|c[\\\\''\"]*(?:o[\\\\''\"]*(?:m[\\\\''\"]*m[\\\\''\"]*a[\\\\''\"]*n[\\\\''\"]*d|p[\\\\''\"]*r[\\\\''\"]*o[\\\\''\"]*c)|u[\\\\''\"]*r[\\\\''\"]*l|s[\\\\''\"]*h|c)|e[\\\\''\"]*(?:g[\\\\''\"]*r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*h[\\\\''\"]*o|v[\\\\''\"]*a[\\\\''\"]*l|x[\\\\''\"]*e[\\\\''\"]*c|n[\\\\''\"]*v)|d[\\\\''\"]*(?:m[\\\\''\"]*e[\\\\''\"]*s[\\\\''\"]*g|a[\\\\''\"]*s[\\\\''\"]*h|i[\\\\''\"]*f[\\\\''\"]*f|o[\\\\''\"]*a[\\\\''\"]*s)|g[\\\\''\"]*(?:z[\\\\''\"]*(?:c[\\\\''\"]*a[\\\\''\"]*t|i[\\\\''\"]*p)|r[\\\\''\"]*e[\\\\''\"]*p|c[\\\\''\"]*c)|j[\\\\''\"]*(?:o[\\\\''\"]*b[\\\\''\"]*s[\\\\''\"]*\s+[\\\\''\"]*-[\\\\''\"]*x|a[\\\\''\"]*v[\\\\''\"]*a)|w[\\\\''\"]*(?:h[\\\\''\"]*o[\\\\''\"]*a[\\\\''\"]*m[\\\\''\"]*i|g[\\\\''\"]*e[\\\\''\"]*t|3[\\\\''\"]*m)|i[\\\\''\"]*r[\\\\''\"]*b(?:[\\\\''\"]*(?:1(?:[\\\\''\"]*[89])?|2[\\\\''\"]*[012]))?|o[\\\\''\"]*n[\\\\''\"]*i[\\\\''\"]*n[\\\\''\"]*t[\\\\''\"]*r|h[\\\\''\"]*(?:e[\\\\''\"]*a[\\\\''\"]*d|u[\\\\''\"]*p)|v[\\\\''\"]*i[\\\\''\"]*(?:g[\\\\''\"]*r|p[\\\\''\"]*w)|G[\\\\''\"]*E[\\\\''\"]*T)[\\\\''\"]*(?:\s|;|\||&|<|>)" "id:932150,phase:2,block,capture,t:none,msg:''Remote Command Execution: Direct Unix Command Execution'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932150, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(21, '远程执行任意命令漏洞932160', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@pmf unix-shell.data" "id:932160,phase:2,block,capture,t:none,t:urlDecodeUni,t:cmdLine,t:normalizePath,t:lowercase,msg:''Remote Command Execution: Unix Shell Code Found'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932160, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(22, '远程执行任意命令漏洞932170', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_HEADERS|REQUEST_LINE "@rx ^\(\s*\)\s+{" "id:932170,phase:2,block,capture,t:none,t:urlDecode,msg:''Remote Command Execution: Shellshock (CVE-2014-6271)'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932170, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(23, '远程执行任意命令漏洞932171', 'alert', 'Y', 1, NULL, 'SecRule ARGS_NAMES|ARGS|FILES_NAMES "@rx ^\(\s*\)\s+{" "id:932171,phase:2,block,capture,t:none,t:urlDecode,t:urlDecodeUni,msg:''Remote Command Execution: Shellshock (CVE-2014-6271)'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932171, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(24, '远程执行任意命令漏洞932180', 'alert', 'Y', 1, NULL, 'SecRule FILES|REQUEST_HEADERS:X-Filename|REQUEST_HEADERS:X_Filename|REQUEST_HEADERS:X-File-Name     "@pmf restricted-upload.data" "id:932180,phase:2,block,capture,t:none,t:lowercase,logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',msg:''Restricted File Upload Attempt'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.lfi_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/FILE_INJECTION-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932180, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(25, '远程执行任意命令漏洞932106', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@rx (?:;|\{|\||\|\||&|&&|\n|\r|\$\(|\$\(\(|`|\${|<\(|>\(|\(\s*\))\s*(?:{|\s*\(\s*|\w+=(?:[^\s]*|\$.*|\$.*|<.*|>.*|\''.*\''|\".*\")\s+|!\s*|\$)*\s*(?:''|\")*(?:[\?\*\[\]\(\)\-\|+\w''\"\./\\\\]+/)?[\\\\''\"]*(?:(?:(?:a[\\\\''\"]*p[\\\\''\"]*t[\\\\''\"]*i[\\\\''\"]*t[\\\\''\"]*u[\\\\''\"]*d|u[\\\\''\"]*p[\\\\''\"]*2[\\\\''\"]*d[\\\\''\"]*a[\\\\''\"]*t)[\\\\''\"]*e|d[\\\\''\"]*n[\\\\''\"]*f|v[\\\\''\"]*i)[\\\\''\"]*(?:\s|<|>).*|p[\\\\''\"]*(?:a[\\\\''\"]*c[\\\\''\"]*m[\\\\''\"]*a[\\\\''\"]*n[\\\\''\"]*(?:\s|<|>).*|w[\\\\''\"]*d|s)|w[\\\\''\"]*(?:(?:\s|<|>).*|h[\\\\''\"]*o))\b" "id:932106,phase:2,block,capture,t:none,msg:''Remote Command Execution: Unix Command Injection'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',tag:''paranoia-level/3'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl3=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932106, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(26, '远程执行任意命令漏洞932190', 'alert', 'Y', 1, NULL, 'SecRule ARGS "@rx (?:/|\\\\)(?:[\?\*]+[a-z/\\\\]+|[a-z/\\\\]+[\?\*]+)" "id:932190,phase:2,block,capture,t:none,t:urlDecode,t:urlDecodeUni,t:normalizePath,t:cmdLine,msg:''Remote Command Execution: Wildcard bypass technique attempt'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-shell'',tag:''platform-unix'',tag:''attack-rce'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',tag:''paranoia-level/3'',ctl:auditLogParts=+E,severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl3=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 12, 932190, 8, '远程执行任意命令漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(27, '目录遍历攻击防护', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_URI|ARGS|REQUEST_HEADERS|!REQUEST_HEADERS:Referer|XML:/* "@rx (?:^|[\\/])\.\.(?:[\\/]|$)" "id:951001,phase:2,block,capture,t:none,t:utf8toUnicode,t:urlDecodeUni,t:removeNulls,t:cmdLine,msg:''Path Traversal Attack (/../)'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-lfi'',tag:''paranoia-level/1'',tag:''OWASP_CRS'',tag:''OWASP_CRS/WEB_ATTACK/DIR_TRAVERSAL'',ver:''OWASP_CRS/3.2.0'',severity:''CRITICAL'',multiMatch,setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.lfi_score=+%{tx.critical_anomaly_score}''"', 11, 951001, 4, '目录遍历攻击防护');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(28, '本地文件包含', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_COOKIES|!REQUEST_COOKIES:/__utm/|REQUEST_COOKIES_NAMES|ARGS_NAMES|ARGS|XML:/* "@pmFromFile lfi-os-files.data" "id:952001,phase:2,block,capture,t:none,t:utf8toUnicode,t:urlDecodeUni,t:normalizePathWin,t:lowercase,msg:''OS File Access Attempt'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-lfi'',tag:''paranoia-level/1'',tag:''OWASP_CRS'',tag:''OWASP_CRS/WEB_ATTACK/FILE_INJECTION'',tag:''WASCTC/WASC-33'',tag:''OWASP_TOP_10/A4'',tag:''PCI/6.5.4'',ver:''OWASP_CRS/3.2.0'',severity:''CRITICAL'',setvar:''tx.lfi_score=+%{tx.critical_anomaly_score}'',setvar:''tx.lfi_score=+%{tx.critical_anomaly_score}''"', 11, 952001, 4, '文件包含攻击防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(29, '远程文件包含952002', 'alert', 'Y', 1, NULL, 'SecRule ARGS "@rx ^(?i:file|ftps?|https?):\/\/(?:\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})" "id:952002,phase:2,block,capture,t:none,msg:''Possible Remote File Inclusion (RFI) Attack: URL Parameter using IP Address'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-rfi'',tag:''paranoia-level/1'',tag:''OWASP_CRS'',tag:''OWASP_CRS/WEB_ATTACK/RFI'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.2.0'',severity:''CRITICAL'',setvar:''tx.rfi_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}''"', 11, 952002, 4, '文件包含攻击防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(30, '远程文件包含952003', 'alert', 'Y', 1, NULL, 'SecRule ARGS "@rx ^(?i:file|ftps?|https?).*?\?+$" "id:952003,phase:2,block,capture,t:none,msg:''Possible Remote File Inclusion (RFI) Attack: URL Payload Used w/Trailing Question Mark Character (?)'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-rfi'',tag:''paranoia-level/1'',tag:''OWASP_CRS'',tag:''OWASP_CRS/WEB_ATTACK/RFI'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.2.0'',severity:''CRITICAL'',setvar:''tx.rfi_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}''"', 11, 952003, 4, '文件包含攻击防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(31, '远程文件包含952004', 'alert', 'Y', 1, NULL, 'SecRule ARGS "@rx ^(?i:file|ftps?|https?)://([^/]*).*$" "id:952004,phase:2,block,capture,t:none,msg:''Possible Remote File Inclusion (RFI) Attack: Off-Domain Reference/Link'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''language-multi'',tag:''platform-multi'',tag:''attack-rfi'',tag:''OWASP_CRS'',tag:''OWASP_CRS/WEB_ATTACK/RFI'',tag:''paranoia-level/2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.2.0'',severity:''CRITICAL'',setvar:''tx.rfi_parameter_%{MATCHED_VAR_NAME}=.%{tx.1}'',chain" SecRule TX:/rfi_parameter_.*/ "!@endsWith .%{request_headers.host}" "setvar:''tx.rfi_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl2=+%{tx.critical_anomaly_score}''"', 11, 952004, 4, '文件包含攻击防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(32, '第三方组件漏洞', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_URI "@pm actionChain1.action" "id:953001,phase:2,block,capture,t:none,t:urlDecodeUni,t:cmdLine,t:normalizePath,t:lowercase,msg:''Third party component vulnerability(S2-057)'',logdata:''Matched Data: %{TX.0} found within %{MATCHED_VAR_NAME}: %{MATCHED_VAR}'',tag:''application-multi'',tag:''attack-strus2'',tag:''OWASP_CRS/WEB_ATTACK/COMMAND_INJECTION'',tag:''WASCTC/WASC-31'',tag:''OWASP_TOP_10/A1'',tag:''PCI/6.5.2'',ctl:auditLogParts=+E,ver:''OWASP_CRS/3.1.0'',severity:''CRITICAL'',setvar:''tx.msg=%{rule.msg}'',setvar:''tx.rce_score=+%{tx.critical_anomaly_score}'',setvar:''tx.anomaly_score_pl1=+%{tx.critical_anomaly_score}'',setvar:''tx.%{rule.id}-OWASP_CRS/WEB_ATTACK/RCE-%{MATCHED_VAR_NAME}=%{tx.0}''"', 11, 953001, 8, '第三方组件漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(33, '反序列化漏洞', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_URI "@pm XbrlPersistenceServlet" "phase:request, rev:''2'', ver:''OWASP_CRS/3.0.0'', maturity:''6'', accuracy:''8'', t:none, block, msg:''NC Java deserialization vulnerability'', id:811001, tag:''application-multi'', tag:''language-multi'', tag:''platform-multi'', tag:''attack-protocol'', tag:''OWASP_CRS/PROTOCOL_VIOLATION/EVASION'', severity:''WARNING'', setvar:''tx.msg=%{rule.msg}'', setvar:tx.anomaly_score=+%{tx.warning_anomaly_score}, setvar:tx.%{rule.id}-OWASP_CRS/PROTOCOL_VIOLATION/EVASION-%{matched_var_name}=%{matched_var}"', 11, 811001, 8, '业务防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(34, 'BSH远程代码执行', 'alert', 'Y', 1, NULL, 'SecRule REQUEST_URI "@pm BshServlet" "phase:request, rev:''2'', ver:''OWASP_CRS/3.0.0'', maturity:''6'', accuracy:''8'', t:none, block, msg:''BSH remote code execution(NC)'', id:811002, tag:''application-multi'', tag:''language-multi'', tag:''platform-multi'', tag:''attack-protocol'', tag:''OWASP_CRS/PROTOCOL_VIOLATION/EVASION'', severity:''WARNING'', setvar:''tx.msg=%{rule.msg}'', setvar:tx.anomaly_score=+%{tx.warning_anomaly_score}, setvar:tx.%{rule.id}-OWASP_CRS/PROTOCOL_VIOLATION/EVASION-%{matched_var_name}=%{matched_var}"', 11, 811002, 8, '业务防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(35, '目录遍历漏洞', 'alert', 'Y', 1, NULL, 'SecRule ARGS "@rx IPreAlertConfigService" "phase:request, rev:''2'', ver:''OWASP_CRS/3.0.0'', maturity:''6'', accuracy:''8'', t:none, block, msg:''Path Traversal Attack(NC)'', id:812001, tag:''application-multi'', tag:''language-multi'', tag:''platform-multi'', tag:''attack-protocol'', tag:''OWASP_CRS/PROTOCOL_VIOLATION/EVASION'', severity:''WARNING'', setvar:''tx.msg=%{rule.msg}'', setvar:tx.anomaly_score=+%{tx.warning_anomaly_score}, setvar:tx.%{rule.id}-OWASP_CRS/PROTOCOL_VIOLATION/EVASION-%{matched_var_name}=%{matched_var}"', 11, 811003, 8, '业务防护规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(36, 'DeleteServlet 反序列化远程命令执行漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 811004, 13, '反序列化远程命令执行');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(37, 'XbrlPersistenceServlet 反序列化远程命令执行漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 811005, 13, '反序列化远程命令执行');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(38, 'monitorservlet 反序列化远程命令执行漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 811006, 13, '反序列化远程命令执行');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(39, 'mxservlet 反序列化远程命令执行漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 811007, 13, '反序列化远程命令执行');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(40, '用友NC系统-XSS1', 'alert', 'Y', 1, NULL, NULL, 11, 812001, 10, 'NC系统XSS漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(41, '用友NC系统-XSS2', 'alert', 'Y', 1, NULL, NULL, 11, 812002, 10, 'NC系统XSS漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(42, '用友NC系统-XSS3', 'alert', 'Y', 1, NULL, NULL, 11, 812003, 10, 'NC系统XSS漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(43, '用友NC系统-XSS4', 'alert', 'Y', 1, NULL, NULL, 11, 812004, 10, 'NC系统XSS漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(44, '用友NC系统SQL注入漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812005, 9, 'NC系统SQL注入漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(45, 'FS文件服务器配置管理存在SQL注入漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812006, 9, 'NC系统SQL注入漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(46, 'XML实体注入漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812007, 13, 'NC系统XML实体注入漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(47, '用友NC系统-任意Url跳转漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812008, 12, 'NC系统-任意Url跳转漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(48, '用友NC系统-commons-fileupload漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812009, 16, '文件上传漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(49, 'FileReceiveServlet任意文件写入漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812010, 16, '文件上传漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(50, 'bsh.servlet.BshServlet 远程命令执行漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812011, 13, '远程命令执行漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(51, '远程执行任意指令漏洞(CVE-2015-4852)', 'alert', 'Y', 1, NULL, NULL, 11, 812012, 13, '远程命令执行漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(52, '用友ERP-NC目录遍历漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 812013, 12, '用友目录遍历漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(53, '用友UFIDA NC信息泄露漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 813001, 12, '用友信息泄露漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(54, '用友NC电子商务采购平台信息泄露漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 813002, 12, '用友信息泄露漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(55, '用友iUFO集团合并报表系统信息泄露漏洞 ', 'alert', 'Y', 1, NULL, NULL, 11, 813003, 12, '用友信息泄露漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(56, '用友NC远程命令执行0-Day漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 814001, 16, '用友0-day漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(57, '用友NC系统-commons-collections Java反序列化漏洞', 'alert', 'Y', 1, NULL, NULL, 11, 814002, 14, '用友反序列化漏洞');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(58, '允许的 HTTP 请求方法', 'alert', 'Y', 1, NULL, NULL, NULL, 601, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(59, '禁止的 HTTP 请求方法', 'alert', 'Y', 1, NULL, NULL, NULL, 602, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(60, '缓存长度限制', 'alert', 'Y', 1, NULL, NULL, NULL, 603, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(61, '传输限制', 'alert', 'Y', 1, NULL, NULL, NULL, 603, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(62, 'Accept 最大长度', 'alert', 'Y', 1, NULL, NULL, NULL, 604, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(63, 'Referer 最大长度', 'alert', 'Y', 1, NULL, NULL, NULL, 604, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(64, 'Accept-Ranges 最大长度', 'alert', 'Y', 1, NULL, NULL, NULL, 605, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(65, 'Server 最大长度', 'alert', 'Y', 1, NULL, NULL, NULL, 605, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(66, '允许的服务器状态码', 'alert', 'Y', 1, NULL, NULL, NULL, 607, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(67, '禁止的服务器状态码', 'alert', 'Y', 1, NULL, NULL, NULL, 608, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(68, 'URL 后缀过滤报警', 'alert', 'Y', 1, NULL, NULL, NULL, 609, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(69, 'URL 后缀过滤阻断', 'alert', 'Y', 1, NULL, NULL, NULL, 610, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(70, 'URL 关键词过滤报警', 'alert', 'Y', 1, NULL, NULL, NULL, 611, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(71, 'URL 关键词过滤阻断', 'alert', 'Y', 1, NULL, NULL, NULL, 612, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(72, '服务器返回的内容报警', 'alert', 'Y', 1, NULL, NULL, NULL, 613, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(73, '服务器返回的内容阻断', 'alert', 'Y', 1, NULL, NULL, NULL, 613, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(74, '编码识别和转换', 'alert', 'Y', 1, NULL, NULL, NULL, 613, 17, 'HTTP校验规则');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(75, '协议执行920120', 'alert', 'Y', 1, NULL, NULL, 8, 920120, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(76, '协议执行920220', 'alert', 'Y', 1, NULL, NULL, 8, 920220, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(77, '协议执行920260', 'alert', 'Y', 1, NULL, NULL, 8, 920260, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(78, '协议执行920460', 'alert', 'Y', 1, NULL, NULL, 8, 920460, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(79, '协议攻击921110', 'alert', 'Y', 1, NULL, NULL, 8, 921110, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(80, '协议攻击921120', 'alert', 'Y', 1, NULL, NULL, 8, 921120, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(81, '协议攻击921130', 'alert', 'Y', 1, NULL, NULL, 8, 921130, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(82, '协议攻击921151', 'alert', 'Y', 1, NULL, NULL, 8, 921151, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(83, '协议攻击921160', 'alert', 'Y', 1, NULL, NULL, 8, 921160, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(84, '协议攻击921200', 'alert', 'Y', 1, NULL, NULL, 8, 921200, 6, '协议完整性');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(85, '本地文件包含930110', 'alert', 'Y', 1, NULL, NULL, 8, 930110, 4, '信息泄露');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(86, '远程执行任意命令漏洞932101', 'alert', 'Y', 1, NULL, NULL, 12, 932101, 8, '其他');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(87, '远程执行任意命令漏洞932200', 'alert', 'Y', 1, NULL, NULL, 12, 932200, 8, '其他');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(88, '远程执行任意命令漏洞932210', 'alert', 'Y', 1, NULL, NULL, 12, 932210, 8, '其他');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(89, 'PHP注入933100', 'alert', 'Y', 1, NULL, NULL, 6, 933100, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(90, 'PHP注入933110', 'alert', 'Y', 1, NULL, NULL, 6, 933110, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(91, 'PHP注入933111', 'alert', 'Y', 1, NULL, NULL, 6, 933111, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(92, 'PHP注入933131', 'alert', 'Y', 1, NULL, NULL, 6, 933131, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(93, 'PHP注入933140', 'alert', 'Y', 1, NULL, NULL, 6, 933140, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(94, 'PHP注入933160', 'alert', 'Y', 1, NULL, NULL, 6, 933160, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(95, 'PHP注入933161', 'alert', 'Y', 1, NULL, NULL, 6, 933161, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(96, 'PHP注入933170', 'alert', 'Y', 1, NULL, NULL, 6, 933170, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(97, 'PHP注入933180', 'alert', 'Y', 1, NULL, NULL, 6, 933180, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(98, 'PHP注入933190', 'alert', 'Y', 1, NULL, NULL, 6, 933190, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(99, 'PHP注入933200', 'alert', 'Y', 1, NULL, NULL, 6, 933200, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(100, 'PHP注入933210', 'alert', 'Y', 1, NULL, NULL, 6, 933210, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(101, 'XSS攻击941110', 'alert', 'Y', 1, NULL, NULL, 7, 941110, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(102, 'XSS攻击941120', 'alert', 'Y', 1, NULL, NULL, 7, 941120, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(103, 'XSS攻击941130', 'alert', 'Y', 1, NULL, NULL, 7, 941130, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(104, 'XSS攻击941140', 'alert', 'Y', 1, NULL, NULL, 7, 941140, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(105, 'XSS攻击941150', 'alert', 'Y', 1, NULL, NULL, 7, 941150, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(106, 'XSS攻击941170', 'alert', 'Y', 1, NULL, NULL, 7, 941170, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(107, 'XSS攻击941190', 'alert', 'Y', 1, NULL, NULL, 7, 941190, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(108, 'XSS攻击941200', 'alert', 'Y', 1, NULL, NULL, 7, 941200, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(109, 'XSS攻击941210', 'alert', 'Y', 1, NULL, NULL, 7, 941210, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(110, 'XSS攻击941220', 'alert', 'Y', 1, NULL, NULL, 7, 941220, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(111, 'XSS攻击941230', 'alert', 'Y', 1, NULL, NULL, 7, 941230, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(112, 'XSS攻击941240', 'alert', 'Y', 1, NULL, NULL, 7, 941240, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(113, 'XSS攻击941250', 'alert', 'Y', 1, NULL, NULL, 7, 941250, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(114, 'XSS攻击941260', 'alert', 'Y', 1, NULL, NULL, 7, 941260, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(115, 'XSS攻击941270', 'alert', 'Y', 1, NULL, NULL, 7, 941270, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(116, 'XSS攻击941280', 'alert', 'Y', 1, NULL, NULL, 7, 941280, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(117, 'XSS攻击941290', 'alert', 'Y', 1, NULL, NULL, 7, 941290, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(118, 'XSS攻击941300', 'alert', 'Y', 1, NULL, NULL, 7, 941300, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(119, 'XSS攻击941310', 'alert', 'Y', 1, NULL, NULL, 7, 941310, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(120, 'XSS攻击941320', 'alert', 'Y', 1, NULL, NULL, 7, 941320, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(121, 'XSS攻击941330', 'alert', 'Y', 1, NULL, NULL, 7, 941330, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(122, 'XSS攻击941340', 'alert', 'Y', 1, NULL, NULL, 7, 941340, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(123, 'XSS攻击941350', 'alert', 'Y', 1, NULL, NULL, 7, 941350, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(124, 'XSS攻击941360', 'alert', 'Y', 1, NULL, NULL, 7, 941360, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(125, 'XSS攻击941370', 'alert', 'Y', 1, NULL, NULL, 7, 941370, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(126, 'XSS攻击941380', 'alert', 'Y', 1, NULL, NULL, 7, 941380, 2, '跨站脚本攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(127, 'Node-JS攻击934100', 'alert', 'Y', 1, NULL, NULL, 7, 934100, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(128, 'SSRF攻击934120', 'alert', 'Y', 1, NULL, NULL, 7, 934120, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(129, 'JavaScript污染攻击934130', 'alert', 'Y', 1, NULL, NULL, 7, 934130, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(130, 'JavaScript污染攻击934131', 'alert', 'Y', 1, NULL, NULL, 7, 934131, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(131, '会话固定攻击943100', 'alert', 'Y', 1, NULL, NULL, 8, 943100, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(132, 'Spring core rce(CVE-2022-22965)', 'alert', 'Y', 1, NULL, NULL, 11, 961001, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(133, 'Spring Cloud Gateway(CVE-2022-22947)', 'alert', 'Y', 1, NULL, NULL, 11, 961002, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(134, 'log4j2(CVE-2021-44228)', 'alert', 'Y', 1, NULL, NULL, 11, 961003, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(135, 'log4j2-数据外带', 'alert', 'Y', 1, NULL, NULL, 11, 961004, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(136, 'Java恶意类攻击', 'alert', 'Y', 1, NULL, NULL, 11, 944100, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(137, 'Struts2-052攻击', 'alert', 'Y', 1, NULL, NULL, 11, 944110, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(138, 'JAVA反序列化攻击', 'alert', 'Y', 1, NULL, NULL, 11, 944120, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(139, 'JAVA攻击944200', 'alert', 'Y', 1, NULL, NULL, 11, 944200, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(140, 'JAVA攻击944210', 'alert', 'Y', 1, NULL, NULL, 11, 944210, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(141, 'JAVA攻击944240', 'alert', 'Y', 1, NULL, NULL, 11, 944240, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(142, 'JAVA攻击944250', 'alert', 'Y', 1, NULL, NULL, 11, 944250, 5, '恶意攻击');
INSERT INTO PUBLIC.RULE (ID, NAME, MODE, STATUS, RISK_LEVEL, REMARK, CONTENT, RULE_ID, CODE, RULE_TYPE, RULE_TYPE_NAME) VALUES(143, 'JAVA攻击944300', 'alert', 'Y', 1, NULL, NULL, 11, 944300, 5, '恶意攻击');
