#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	  # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

_K=$1

if [ "#$_K" != "#" ] && [ ! -f $_K ] ; then
  echo "key bin: $_K, no such file."
fi

chmod +x *.sh
for bin in ospshell-cli eis-cli upgrade40-cli upgrade40-rules sniperknl-crontab
do
  [ -f ${bin} ] && chmod +x ${bin}
done

# 停止当前正在运行的客户端
if [ -f /usr/local/sniper/sniper ] ; then
  /usr/local/sniper/shutdown.sh force
fi

# 检查客户端是否已经安装，如果已经安装则先将客户端备份到 /tmp目录下
if [ -d /usr/local/sniper ] ; then
  mkdir -p /tmp/install_backup
  cp -r /usr/local/sniper /tmp/install_backup/

  # 安装新版本客户端，如果安装失败，则删除/tmp下的备份，如果成功，将 /tmp下的备份转移到安装目录进行备份，如：/usr/local/sniper.old
  # 执行升级卸载
  /usr/local/sniper/uninstall.sh upgrade 1> /dev/null

  # 安装新版本客户端
  ./pure-install.sh

  # 备份旧的备份
  if [ -d /usr/local/sniper.old ] ; then
    rm -rf /usr/local/sniper.old.${DATE}
    mv /usr/local/sniper.old /usr/local/sniper.old.${DATE}
  fi

  # 临时备份转移成正式的版本备份
  mv /tmp/install_backup/sniper /usr/local/sniper.old
  rm -rf /tmp/install_backup/

  # 发送当前版本客户端卸载命令到服务端中
  cd /usr/local/sniper.old/ && /usr/local/sniper.old/sniper -o uninstall
  cd ${DIR}

  # 还原配置文件，例如 .file_server_address whitelist.rc config/.data_reducer.config config/key.bin
  for config in .file_server_address whitelist.rc config/.data_reducer.config config/key.bin custom_rules
  do
    if [ -f "/usr/local/sniper.old/${config}" ] || [ -d "/usr/local/sniper.old/${config}" ] ; then
      echo "copy $config to /usr/local/sniper"
      cp -r "/usr/local/sniper.old/${config}" "/usr/local/sniper/$(dirname ${config})"
    fi
  done
  # 删除更老的版本
  if [ -d "/usr/local/sniper.old.${DATE}" ] ; then
    rm -rf "/usr/local/sniper.old.${DATE}"
  fi

  if [ "#${_K}" != "#" ] && [ -f "${_K}" ] ; then
    echo "copy the ${_K} to the dir /usr/local/sniper/config"
    /usr/local/sniper/regist.sh "${_K}"
  fi
else
  ./pure-install.sh "${_K}"
fi

# 安装客户端补丁包
if [ -f patch/install.sh ] ; then
  chmod +x patch/install.sh
  ./patch/install.sh
fi

echo "please using 'sniper-start' to startup the client manually!!!"
